<?php

namespace WeDevs\Wpuf\Pro\Integrations\Events_Calendar\Handlers;

/**
 * Venue Handler for Events Calendar (Pro)
 *
 * Handles venue creation and updates using The Events Calendar ORM API.
 *
 * @since 4.1.8
 */
class Venue_Handler {
    /**
     * Create or update a venue from post data
     *
     * @param array $post_data (optional, defaults to $_POST)
     * @return int|false Venue post ID or false on failure
     */
    public static function create_or_update_venue_from_post( $post_data = null ) {
        if ( is_null( $post_data ) ) {
            $post_data = $_POST;
        }

        // Only create if user selected 'create' for venue
        if ( empty( $post_data['venue'] ) || $post_data['venue'] !== 'create' ) {
            return ! empty( $post_data['_EventVenueID'] ) ? $post_data['_EventVenueID'] : false;
        }

        // Extract and sanitize venue fields
        $venue_args = [];
        $venue_args['venue'] = isset( $post_data['venue_name'] ) ? sanitize_text_field( $post_data['venue_name'] ) : '';
        $venue_args['phone'] = isset( $post_data['venue_phone'] ) ? sanitize_text_field( $post_data['venue_phone'] ) : '';
        $venue_args['website'] = isset( $post_data['venue_website'] ) ? esc_url_raw( $post_data['venue_website'] ) : '';

        // Address fields (from address field array)
        if ( ! empty( $post_data['venue_address'] ) && is_array( $post_data['venue_address'] ) ) {
            $address = $post_data['venue_address'];
            $venue_args['address'] = isset( $address['street_address'] ) ? sanitize_text_field( $address['street_address'] ) : '';
            $venue_args['city'] = isset( $address['city_name'] ) ? sanitize_text_field( $address['city_name'] ) : '';
            $venue_args['state'] = isset( $address['state'] ) ? sanitize_text_field( $address['state'] ) : '';
            $venue_args['zip'] = isset( $address['zip'] ) ? sanitize_text_field( $address['zip'] ) : '';
            // The Events Calendar expects full country name, but we may only have code
            $venue_args['country'] = isset( $address['country_select'] ) ? sanitize_text_field( $address['country_select'] ) : '';
        }

        // Show map options
        $venue_args['show_map'] = ! empty( $post_data['_EventShowMap'] ) && ( $post_data['_EventShowMap'] === '1' || ( is_array( $post_data['_EventShowMap'] ) && in_array( '1', $post_data['_EventShowMap'] ) ) );
        $venue_args['show_map_link'] = ! empty( $post_data['_EventShowMapLink'] ) && ( $post_data['_EventShowMapLink'] === '1' || ( is_array( $post_data['_EventShowMapLink'] ) && in_array( '1', $post_data['_EventShowMapLink'] ) ) );

        // Required: venue name
        if ( empty( $venue_args['venue'] ) ) {
            return false;
        }

        // Create the venue using TEC ORM
        if ( function_exists( 'tribe_venues' ) ) {
            $venue = tribe_venues()->set_args( $venue_args )->create();
            if ( $venue instanceof \WP_Post ) {
                return $venue->ID;
            }
        }
        return false;
    }
}
