# Development Environment Setup

## Prerequisites

- Node.js 16+ and npm
- WordPress development environment
- WP User Frontend PRO plugin

## Quick Start

### 1. Install Dependencies
```bash
npm install
```

### 2. Development Commands

#### Start Development Build
```bash
npm run dev
# or
npm run start
```

#### Build for Production
```bash
npm run build
```

#### Lint Code
```bash
npm run lint
npm run lint:fix  # Auto-fix issues
```

**Note**: We use `@wordpress/scripts` which provides webpack, ESLint, and other build tools automatically.

#### Build Layout CSS
```bash
npm run build:layouts
npm run watch:layouts  # Watch for changes
```

## Project Structure

```
src/
├── js/
│   ├── blocks/           # Gutenberg blocks
│   │   ├── index.js      # Block registration
│   │   ├── registry.js   # Block registry system
│   │   └── template/     # Standard block template
│   └── wpuf-ud.js        # Main script
├── css/                  # CSS source files
└── settings-schema.json  # Block settings schema
```

## Block Development

### Creating a New Block

1. **Use the template**: Copy `src/js/blocks/template/` to create new blocks
2. **Register in registry**: Add to `src/js/blocks/registry.js`
3. **Follow naming**: Use `wpuf-ud/` namespace for block names

### Block Structure
```
block-name/
├── index.js      # Block registration
├── edit.js       # Edit component
├── save.js       # Save component
├── block.json    # Block metadata
├── style.css     # Block styles
└── README.md     # Block documentation
```

## Code Standards

### JavaScript
- Follow WordPress coding standards
- Use ESLint for code quality
- Use JSDoc for documentation

### CSS
- Use Tailwind CSS for styling
- Follow BEM methodology for custom classes
- Use CSS custom properties for theming

## Build Process

### Build Configuration
- **Entry point**: `src/js/wpuf-ud.js` (main entry)
- **Output**: JS to `build/`, CSS to `build/`
- **Optimization**: Production builds are optimized and minified
- **WordPress Scripts**: Uses `@wordpress/scripts` for standardized build process

### Development vs Production
- **Development**: Source maps, watch mode, unminified
- **Production**: Minified, optimized, no source maps

## Troubleshooting

### Common Issues

1. **Build fails**: Check for syntax errors with `npm run lint`
2. **Blocks not appearing**: Verify block registration in registry
3. **Styles not loading**: Check CSS build process

### Debug Mode
Enable WordPress debug mode in `wp-config.php`:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

## Next Steps

- [ ] Complete block cleanup and organization
- [ ] Implement testing framework
- [ ] Add performance monitoring
- [ ] Create deployment pipeline
