import { __ } from '@wordpress/i18n';
import { useBlockProps } from '@wordpress/block-editor';
import { TextControl, SelectControl } from '@wordpress/components';
import { Fragment } from '@wordpress/element';
import StandardInspectorControls, { StandardPanelRow, createInspectorControls } from '../../components/InspectorControls/StandardInspectorControls';

const Edit = ({ attributes, setAttributes, context }) => {
    const { buttonText, linkTarget, rel } = attributes;

    // Get user data from context (Query Loop style)
    	const userData = context?.['wpuf-ud/userObject'] || {
        id: 1,
        user_login: 'sampleuser',
        display_name: __('Sample User', 'wpuf-pro'),
        user_email: 'sample@example.com'
    };

    // Detect container context for styling
    	const containerLayout = context?.['wpuf-ud/containerLayout'] || 'default';
	const isInDirectory = context?.['wpuf-ud/isDirectoryMode'] || false;

    const blockProps = useBlockProps({
        className: `wpuf-profile-button wpuf-container-${containerLayout} ${isInDirectory ? 'wpuf-in-directory' : 'wpuf-in-profile'}`
    });

    // Create organized inspector controls
    const inspectorControls = createInspectorControls({
        content: (
            <>
                <StandardPanelRow>
                    <TextControl
                        label={__('Button Text', 'wpuf-pro')}
                        value={buttonText}
                        onChange={(value) => setAttributes({ buttonText: value })}
                        placeholder={__('View Profile', 'wpuf-pro')}
                        __next40pxDefaultSize={true}
                        __nextHasNoMarginBottom={true}
                    />
                </StandardPanelRow>
                
                <StandardPanelRow>
                    <SelectControl
                        label={__('Link Target', 'wpuf-pro')}
                        value={linkTarget}
                        options={[
                            { label: __('Same Window', 'wpuf-pro'), value: '_self' },
                            { label: __('New Window', 'wpuf-pro'), value: '_blank' }
                        ]}
                        onChange={(value) => setAttributes({ linkTarget: value })}
                        __next40pxDefaultSize={true}
                        __nextHasNoMarginBottom={true}
                    />
                </StandardPanelRow>
            </>
        ),
        advanced: (
            <StandardPanelRow>
                <TextControl
                    label={__('Rel Attribute', 'wpuf-pro')}
                    value={rel}
                    onChange={(value) => setAttributes({ rel: value })}
                    placeholder="noopener noreferrer"
                    help={__('Optional rel attribute for the link', 'wpuf-pro')}
                    __next40pxDefaultSize={true}
                    __nextHasNoMarginBottom={true}
                />
            </StandardPanelRow>
        )
    });

    return (
        <Fragment>
            <StandardInspectorControls 
                displayPanel={false}
                contentPanelTitle={__('Button Settings', 'wpuf-pro')}
                contentPanelInitialOpen={true}
            >
                {inspectorControls}
            </StandardInspectorControls>

            <div {...blockProps}>
                <a 
                    href="#"
                    target={linkTarget}
                    rel={rel}
                    className="wpuf-profile-button-link"
                >
                    {buttonText || __('View Profile', 'wpuf-pro')}
                </a>
            </div>
        </Fragment>
    );
};

export default Edit;
