// User Custom Field Block Registration
// Registers the WPUF User Custom Field inner block

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Custom Field', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="18" viewBox="0 0 18 18" fill="#fff" xmlns="http://www.w3.org/2000/svg">
        <rect x="2.25" y="2.25" width="13.5" height="13.5" rx="1" stroke="#059669" fill="#fff" strokeWidth="1.5"/>
        <path d="M5.25 6H12.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
        <path d="M5.25 9H12.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
        <path d="M5.25 12H9.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
