import { __ } from '@wordpress/i18n';
import { Modal, Button } from '@wordpress/components';

// Confirmation Modal Component for Directory Layout Changes
const DirectoryConfirmationModal = ({ isOpen, onConfirm, onCancel, title, message, confirmText, cancelText }) => {
    if (!isOpen) return null;

    return (
        <Modal
            title={title}
            onRequestClose={onCancel}
            className="wpuf-directory-confirmation-modal"
        >
            <div className="wpuf-modal-content">
                <p>{message}</p>
                <div className="wpuf-modal-actions">
                    <Button
                        variant="secondary"
                        onClick={onCancel}
                    >
                        {cancelText}
                    </Button>
                    <Button
                        variant="primary"
                        onClick={onConfirm}
                        className="wpuf-confirm-button"
                    >
                        {confirmText}
                    </Button>
                </div>
            </div>
        </Modal>
    );
};

export default DirectoryConfirmationModal;
