/**
 * WordPress dependencies
 */
import { useSelect } from '@wordpress/data';
import { store as blockEditorStore } from '@wordpress/block-editor';

/**
 * Internal dependencies
 */
import UserDirectoryContent from './user-directory-content';
import UserDirectoryPlaceholder from './user-directory-placeholder';

const UserDirectoryEdit = (props) => {
	const { clientId, attributes } = props;

	const hasInnerBlocks = useSelect(
		(select) => !!select(blockEditorStore).getBlocks(clientId).length,
		[clientId]
	);

	// Check if layout has been selected
	const hasSelectedLayout = attributes.hasSelectedLayout || false;

	// Show placeholder if no layout selected or no inner blocks
	// BUT if we're switching layouts, always show content component
	// AND if it's a table layout, always show content component (settings-driven)
	const isSwitchingLayout = attributes.isSwitchingLayout || false;
	const isTableLayout = attributes.directory_layout === 'table';
	const showPlaceholder = (!hasSelectedLayout || (!hasInnerBlocks && !isTableLayout)) && !isSwitchingLayout;

	const Component = showPlaceholder ? UserDirectoryPlaceholder : UserDirectoryContent;

	return <Component {...props} />;
};

export default UserDirectoryEdit;
