/**
 * WordPress dependencies
 */
import {
	ToolbarGroup,
	ToolbarButton,
	Dropdown,
	__experimentalDropdownContentWrapper as DropdownContentWrapper,
} from '@wordpress/components';
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import PatternSelection, { useBlockPatterns } from './pattern-selection';

export default function UserDirectoryToolbar({ clientId, attributes }) {
	const hasPatterns = useBlockPatterns(clientId, attributes).length;
	if (!hasPatterns) {
		return null;
	}

	return (
		<ToolbarGroup className="wpuf-user-directory__block-control-group">
			<DropdownContentWrapper>
				<Dropdown
					contentClassName="block-editor-block-settings-menu__popover"
					focusOnMount="firstElement"
					expandOnMobile
					renderToggle={({ isOpen, onToggle }) => (
						<ToolbarButton
							aria-haspopup="true"
							aria-expanded={isOpen}
							onClick={onToggle}
						>
							{__('Change layout', 'wpuf-pro')}
						</ToolbarButton>
					)}
					renderContent={() => (
						<PatternSelection
							clientId={clientId}
							attributes={attributes}
							showSearch={false}
							showTitlesAsTooltip
						/>
					)}
				/>
			</DropdownContentWrapper>
		</ToolbarGroup>
	);
} 