import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('Message Button', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M10.2322 2.24151C11.2085 1.2652 12.7915 1.2652 13.7678 2.24151C14.7441 3.21782 14.7441 4.80073 13.7678 5.77704L12.5434 7.00138C12.2505 7.29427 12.2505 7.76914 12.5434 8.06204C12.8363 8.35493 13.3112 8.35493 13.6041 8.06204L14.8284 6.8377C16.3905 5.27561 16.3905 2.74295 14.8284 1.18085C13.2663 -0.381247 10.7337 -0.381247 9.17157 1.18085L6.17157 4.18085C4.60948 5.74295 4.60948 8.27561 6.17157 9.8377C6.24449 9.91062 6.31963 9.98022 6.3968 10.0465C6.71107 10.3163 7.18457 10.2803 7.45441 9.96603C7.72424 9.65176 7.68822 9.17826 7.37395 8.90842C7.32556 8.86687 7.27828 8.82309 7.23223 8.77704C6.25592 7.80073 6.25592 6.21782 7.23223 5.24151L10.2322 2.24151Z" fill="#059669"/>
        <path d="M9.6032 5.97206C9.28893 5.70223 8.81542 5.73825 8.54559 6.05251C8.27576 6.36678 8.31178 6.84029 8.62605 7.11012C8.67444 7.15167 8.72172 7.19546 8.76777 7.2415C9.74408 8.21781 9.74408 9.80072 8.76777 10.777L5.76777 13.777C4.79146 14.7533 3.20854 14.7533 2.23223 13.777C1.25592 12.8007 1.25592 11.2178 2.23223 10.2415L3.45657 9.01716C3.74946 8.72427 3.74946 8.2494 3.45657 7.9565C3.16367 7.66361 2.6888 7.66361 2.39591 7.9565L1.17157 9.18084C-0.390524 10.7429 -0.390524 13.2756 1.17157 14.8377C2.73367 16.3998 5.26633 16.3998 6.82843 14.8377L9.82843 11.8377C11.3905 10.2756 11.3905 7.74294 9.82843 6.18084C9.75551 6.10792 9.68037 6.03832 9.6032 5.97206Z" fill="#059669"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
