import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Social Fields', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="18" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg">
        <circle cx="9" cy="9" r="2" fill="#059669"/>
        <circle cx="4" cy="6" r="1.5" fill="#059669"/>
        <circle cx="14" cy="6" r="1.5" fill="#059669"/>
        <circle cx="4" cy="12" r="1.5" fill="#059669"/>
        <circle cx="14" cy="12" r="1.5" fill="#059669"/>
        <path d="M9 7L4 6M9 7L14 6M9 11L4 12M9 11L14 12" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
