/**
 * Standard Block Template - save.js
 *
 * Save component template for WPUF User Directory blocks.
 * This component handles the block's HTML output on the frontend.
 *
 * @since 4.2.0
 */

import { useBlockProps } from '@wordpress/block-editor';

/**
 * Save Component
 *
 * @param {Object} props - Component props
 * @param {Object} props.attributes - Block attributes
 * @returns {JSX.Element} Save component
 */
export default function Save({ attributes }) {
    const blockProps = useBlockProps.save({
        className: 'wpuf-block-template',
    });

    /**
     * Generate CSS classes based on attributes
     *
     * @returns {string} CSS classes
     */
    const getBlockClasses = () => {
        const classes = ['wpuf-block-template'];

        // Add display style class
        if (attributes.displayStyle) {
            classes.push(`wpuf-display-${attributes.displayStyle}`);
        }

        // Add custom CSS class
        if (attributes.className) {
            classes.push(attributes.className);
        }

        // Add animation class
        if (attributes.enableAnimation) {
            classes.push('wpuf-animation-enabled');
        }

        return classes.join(' ');
    };

    /**
     * Generate inline styles based on attributes
     *
     * @returns {Object} Inline styles
     */
    const getBlockStyles = () => {
        const styles = {};

        // Add font size
        if (attributes.fontSize) {
            styles.fontSize = `${attributes.fontSize}px`;
        }

        // Add custom colors
        if (attributes.textColor) {
            styles.color = attributes.textColor;
        }

        if (attributes.backgroundColor) {
            styles.backgroundColor = attributes.backgroundColor;
        }

        return styles;
    };

    /**
     * Render block content
     *
     * @returns {JSX.Element} Block HTML
     */
    return (
        <div
            {...blockProps}
            className={getBlockClasses()}
            style={getBlockStyles()}
        >
            <div className="wpuf-block-template-content">
                {/* Block content goes here */}
                <div className="wpuf-block-content">
                    {/* This is where the actual block content will be rendered */}
                    {/* Replace this with your specific block implementation */}

                    {/* Example structure */}
                    <div className="wpuf-block-wrapper">
                        {attributes.showLabel && (
                            <div className="wpuf-block-label">
                                {attributes.customLabel || 'Block Label'}
                            </div>
                        )}

                        <div className="wpuf-block-data">
                            {/* Dynamic content will be rendered here by PHP */}
                            <div className="wpuf-dynamic-content">
                                {/* wpuf:dynamic-content */}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}
