import React, { useEffect, useState } from 'react';

const Modal = ({ isOpen, onClose, children }) => {
    const [show, setShow] = useState(isOpen);
    const [animate, setAnimate] = useState(false);

    useEffect(() => {
        if (isOpen) {
            setShow(true);
            // Start animation on next tick
            setTimeout(() => setAnimate(true), 10);
        } else if (show) {
            setAnimate(false);
            // Wait for animation to finish before unmounting
            const timeout = setTimeout(() => setShow(false), 300);
            return () => clearTimeout(timeout);
        }
    }, [isOpen]);

    if (!show) return null;

    return (
        <div className="wpuf-absolute wpuf-inset-0 wpuf-z-50 wpuf-bg-white">
            <div className="wpuf-flex wpuf-justify-center wpuf-min-h-screen wpuf-px-4 wpuf-py-6 wpuf-text-center">
                <div className="wpuf-absolute wpuf-inset-0 wpuf-transition-opacity" onClick={onClose}></div>

                <div
                    className={`wpuf-relative wpuf-bg-white wpuf-transform wpuf-transition-all wpuf-duration-300 wpuf-ease-in-out wpuf-w-full wpuf-h-full ${animate ? 'wpuf-scale-100 wpuf-opacity-100' : 'wpuf-scale-95 wpuf-opacity-0'}`}
                >
                    <div className="wpuf-p-6">
                        {children}
                    </div>
                </div>
            </div>
        </div>
    );
};

export default Modal;
