import React from 'react';
import { __ } from '@wordpress/i18n';

const ProfileLayout = ({ formData, setFormData }) => {
    const handleChange = (e) => {
        const { name, value } = e.target;
        setFormData(prev => ({ ...prev, [name]: value }));
    };

    const layoutOptions = wpuf_ud.profile_layouts || {};

    return (
        <div className="wpuf-w-full wpuf-bg-white wpuf-max-w-3xl wpuf-mx-auto">
            <h2 className="wpuf-text-center"
                style={{
                    
                    fontWeight: 400,
                    fontSize: '20px',
                    lineHeight: '36px',
                    letterSpacing: '0%',
                    textAlign: 'center',
                    color: '#000000'
                }}
            >
                {__('Profile Layout', 'wpuf-pro')}
            </h2>
            <p className="wpuf-text-center wpuf-mt-2"
                style={{
                    
                    fontWeight: 400,
                    fontSize: '14px',
                    lineHeight: '20px',
                    letterSpacing: '0%',
                    textAlign: 'center',
                    color: '#64748B'
                }}
            >{__('Decide how individual user profiles will appear. Select a layout that best organizes profile information', 'wpuf-pro')}</p>
            <div className="wpuf-grid wpuf-grid-cols-3 wpuf-gap-2 wpuf-mt-12">
                {Object.entries(layoutOptions).map(([value, option]) => (
                    <label
                        key={value}
                        className={`wpuf-relative wpuf-cursor-pointer wpuf-flex wpuf-flex-col wpuf-items-center wpuf-transition-all wpuf-duration-200 wpuf-group wpuf-overflow-hidden`}
                        style={{
                            width: '255px',
                            height: '182px',
                            borderRadius: '10px',
                            borderWidth: '1px',
                            borderStyle: 'solid',
                            borderColor: formData.profile_layout === value ? '#059669' : '#E5E7EB',
                            backgroundColor: '#FFFFFF',
                            opacity: 1
                        }}
                    >
                        <input
                            type="radio"
                            name="profile_layout"
                            value={value}
                            checked={formData.profile_layout === value}
                            onChange={handleChange}
                            className="wpuf-sr-only"
                        />
                        <img
                            src={option.image}
                            alt={option.name}
                            style={{ 
                                maxWidth: '100%',
                                maxHeight: '100%',
                                padding: '10px',
                                imageRendering: 'crisp-edges', 
                                WebkitFontSmoothing: 'antialiased' 
                            }}
                        />
                        {/* Hover overlay with layout name - Full card size */}
                        <div 
                            className="wpuf-absolute wpuf-inset-0 wpuf-flex wpuf-items-center wpuf-justify-center wpuf-opacity-0 group-hover:wpuf-opacity-100 wpuf-transition-opacity wpuf-duration-300"
                            style={{
                                backgroundColor: 'rgba(236, 253, 245, 0.95)',
                                borderRadius: '10px'
                            }}
                        >
                            <span 
                                style={{
                                    
                                    fontSize: '16px',
                                    fontWeight: 600,
                                    color: '#059669'
                                }}
                            >{option.name}</span>
                        </div>
                        {formData.profile_layout === value && (
                            <span 
                                className="wpuf-absolute wpuf-flex wpuf-items-center wpuf-justify-center wpuf-z-10"
                                style={{
                                    width: '20px',
                                    height: '20px',
                                    borderRadius: '23px',
                                    backgroundColor: '#059669',
                                    top: '12px',
                                    right: '12px',
                                    opacity: 1
                                }}
                            >
                                <svg width="8" height="6" viewBox="0 0 8 6" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1.49927 2.5L3.49927 4.5L6.99927 1" stroke="white" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                                </svg>
                            </span>
                        )}
                    </label>
                ))}
            </div>
        </div>
    );
};

export default ProfileLayout;
