<div class="wpuf-user-listing" data-block-id="<?php echo esc_attr( $block_id ); ?>" data-page-id="<?php echo esc_attr( $page_id ); ?>" data-layout="<?php echo esc_attr( ! empty( $directory_layout ) ? $directory_layout : 'layout-1' ); ?>" <?php if ( ! empty( $all_data['id'] ) ) : ?>data-directory-id="<?php echo esc_attr( $all_data['id'] ); ?>"<?php endif; ?> <?php if ( ! empty( $columns ) ) : ?>data-columns="<?php echo esc_attr( implode( ',', $columns ) ); ?>"<?php endif; ?> <?php if ( isset( $all_data['show_avatar_in_table'] ) ) : ?>data-show-avatar-in-table="<?php echo esc_attr( $all_data['show_avatar_in_table'] ? 'true' : 'false' ); ?>"<?php endif; ?> <?php if ( ! empty( $avatar_size ) ) : ?>data-avatar-size="<?php echo esc_attr( $avatar_size ); ?>"<?php endif; ?> <?php if ( ! empty( $all_data['max_item'] ) ) : ?>data-max-item="<?php echo esc_attr( $all_data['max_item'] ); ?>"<?php endif; ?>>
    <!-- Search and Filter Controls -->
    <?php 
    // Check if either search or sorting is enabled
    $show_header = ! empty( $enable_search ) || ! empty( $enable_frontend_sorting );
    
    if ( $show_header ) : ?>
        <div class="wpuf-user-directory-header !wpuf-flex !wpuf-justify-between !wpuf-items-center !wpuf-my-8 !wpuf-gap-4">
            
            <!-- Search Field -->
            <?php
                if ( ! empty( $enable_search ) ) {
                    include WPUF_UD_TEMPLATES . '/shortcodes/directory/template-parts/search-field.php';
                }
            ?>
            
            <!-- Sort and Filter Fields -->
            <?php
                // Include the sorting and filter controls if frontend sorting is enabled
                if ( ! empty( $enable_frontend_sorting ) ) {
                    $layout = ! empty( $directory_layout ) ? $directory_layout : 'layout-1';
                    include WPUF_UD_TEMPLATES . '/shortcodes/directory/template-parts/sort-field.php';
                }
            ?>
            
        </div>
    <?php endif; ?>
    <div class="wpuf-ud-list wpuf-ud-list-layout-1 wpuf-flow-root">
        <?php if ( ! empty( $users ) ) { ?>
            <div class="wpuf--mx-4 wpuf--my-2 wpuf-overflow-x-auto sm:wpuf--mx-6 lg:wpuf--mx-8">
                <div class="wpuf-inline-block wpuf-min-w-full wpuf-py-2 wpuf-align-middle sm:wpuf-px-6 lg:wpuf-px-8">
                    <div class="wpuf-overflow-hidden wpuf-shadow wpuf-rounded-lg wpuf-border wpuf-border-gray-300">
                        <table class="wpuf-ud-table wpuf-min-w-full wpuf-divide-y wpuf-divide-gray-300">
                            <thead class="wpuf-ud-thead wpuf-bg-gray-50">
                                <tr>
                                    <?php
                                    $localize_obj = wpuf_ud_get_localize_object();
                                    $default_columns = ! empty( $localize_obj['columns'] ) ? $localize_obj['columns'] : [];
                                    
                                    // Merge with meta field columns if available
                                    if ( ! empty( $all_data['meta_field_columns'] ) ) {
                                        $default_columns = array_merge( $default_columns, $all_data['meta_field_columns'] );
                                    }
                                    ?>
                                    <?php
                                    foreach ( $columns as $column ) {
                                        ?>
                                        <th scope="col"
                                            class="wpuf-p-4 wpuf-text-center wpuf-text-sm wpuf-font-semibold wpuf-text-blue-500">
                                            <?php 
                                            // Display column label
                                            if ( isset( $default_columns[ $column ] ) ) {
                                                echo esc_html( $default_columns[ $column ] );
                                            } else {
                                                // Fallback to formatted column name
                                                echo esc_html( ucwords( str_replace( [ '_', '-' ], ' ', $column ) ) );
                                            }
                                            ?>
                                        </th>
                                        <?php
                                    }
                                    ?>
                                    <th scope="col"
                                        class="wpuf-p-4 wpuf-text-center wpuf-text-sm wpuf-font-semibold wpuf-text-blue-500">
                                        <?php esc_html_e( 'Action', 'wpuf-pro' ); ?>
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="wpuf-ud-tbody wpuf-divide-y wpuf-divide-gray-200 wpuf-bg-white">
                                <?php
                                    $row = WPUF_UD_TEMPLATES . '/shortcodes/directory/template-parts/row-1.php';

                                    if ( file_exists( $row ) ) {
                                        foreach ( $users as $user ) {
                                            // Pass block attributes to row template if available
                                            $row_data = [
                                                'user' => $user,
                                                'columns' => $columns,
                                                'avatar_size' => $avatar_size,
                                                'all_data' => $all_data ?? [],
                                                'profile_url_helper' => $profile_url_helper ?? null,
                                                'block_attributes' => $block_attributes ?? [],
                                                'styling_helper' => $styling_helper ?? null
                                            ];
                                            
                                            // Extract variables for row template
                                            extract( $row_data );
                                            
                                            include $row;
                                        }
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php } else { ?>
            <div class="wpuf-no-users-container !wpuf-flex !wpuf-items-center !wpuf-justify-center !wpuf-min-h-[400px]">
                <div class="wpuf-no-users-found !wpuf-flex !wpuf-flex-col !wpuf-items-center !wpuf-justify-center !wpuf-text-center">
                    <div class="!wpuf-bg-gray-100 !wpuf-rounded-full !wpuf-p-4 !wpuf-mb-4">
                        <svg class="!wpuf-w-12 !wpuf-h-12 !wpuf-text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <h3 class="!wpuf-text-base !wpuf-font-semibold !wpuf-text-gray-900 !wpuf-mb-2">
                        <?php esc_html_e('No users found matching your search criteria.', 'wpuf-pro'); ?>
                    </h3>
                    <p class="!wpuf-text-sm !wpuf-text-gray-500">
                        <?php esc_html_e('Try adjusting your search or filter to find what you\'re looking for.', 'wpuf-pro'); ?>
                    </p>
                </div>
            </div>
        <?php } ?>
    </div>
    <div class="wpuf-ud-pagination">
        <?php
            // Use different pagination template based on context
            // Check if this is a shortcode context (not a block context)
            $is_shortcode = empty( $block_id ) || strpos( $block_id, 'shortcode_' ) === 0;
            
            if ( $is_shortcode ) {
                // Use shortcode-specific pagination template
                $layout = ! empty( $directory_layout ) ? $directory_layout : 'layout-1';
                
                // Prepare query args for pagination links
                $current_url = ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
                $parsed_url = wp_parse_url( $current_url );
                $base_url = $parsed_url['path'] ?? '';
                
                $query_args = [];
                if ( ! empty( $parsed_url['query'] ) ) {
                    parse_str( $parsed_url['query'], $query_args );
                }
                
                // Ensure directory_layout is included in pagination links
                $query_args['directory_layout'] = $layout;
                unset( $query_args['page'] ); // Will be set per link
                
                include WPUF_UD_TEMPLATES . '/shortcodes/directory/template-parts/pagination-shortcode.php';
            } else {
                // Use default block pagination template
                include WPUF_UD_TEMPLATES . '/shortcodes/directory/template-parts/pagination.php';
            }
        ?>
    </div>
</div>
