<?php
$tab_title = ! empty( $tab_title ) ? $tab_title : __( 'Comments', 'wpuf-pro' );

$comments_per_page = 10;

// Get current page for comments pagination
$current_comments_page = max( 1, get_query_var( 'comments_page' ) );
if ( ! $current_comments_page ) {
    $current_comments_page = isset( $_GET['comments_page'] ) ? intval( $_GET['comments_page'] ) : 1;
}

// Calculate offset for pagination
$offset = ( $current_comments_page - 1 ) * $comments_per_page;

// Get user comments with pagination
$comments = get_comments([
    'user_id' => $user->ID,
    'status'  => 'approve',
    'number'  => $comments_per_page,
    'offset'  => $offset,
    'orderby' => 'comment_date',
    'order'   => 'DESC'
]);

// Get total count for pagination
$comments_count = get_comments([
    'count'   => true,
    'user_id' => $user->ID,
    'status'  => 'approve'
]);
?>

<div class="wpuf-profile-section wpuf-comments-section !wpuf-mb-8">
    <h1 class="profile-section-heading !wpuf-text-2xl !wpuf-font-bold !wpuf-text-gray-900 !wpuf-mb-6">
        <?php echo esc_html( $tab_title ); ?>
    </h1>

    <?php if ( ! empty( $comments ) ) : ?>
        <div class="comments-list !wpuf-space-y-4">
            <?php foreach ( $comments as $comment ) : ?>
                <div class="comment-item !wpuf-bg-white !wpuf-p-6 !wpuf-rounded-xl !wpuf-border !wpuf-border-gray-200 hover:!wpuf-border-blue-200 !wpuf-transition-colors !wpuf-duration-200">
                    <div class="comment-header !wpuf-flex !wpuf-justify-between !wpuf-items-start !wpuf-mb-4">
                        <div class="comment-meta">
                            <h4 class="commented-post !wpuf-font-semibold !wpuf-text-gray-900 !wpuf-text-base !wpuf-mb-1">
                                <?php echo esc_html( get_the_title( $comment->comment_post_ID ) ); ?>
                            </h4>
                            <div class="comment-date !wpuf-text-sm !wpuf-text-gray-500">
                                <?php echo esc_html( mysql2date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $comment->comment_date ) ); ?>
                            </div>
                        </div>
                        <a href="<?php echo get_comment_link( $comment ); ?>" 
                           target="_blank"
                           class="comment-link !wpuf-inline-flex !wpuf-items-center !wpuf-gap-1 !wpuf-px-3 !wpuf-py-1.5 !wpuf-text-xs !wpuf-font-medium !wpuf-text-blue-500 !wpuf-bg-blue-50 !wpuf-rounded-lg hover:!wpuf-bg-blue-100 !wpuf-transition-colors !wpuf-no-underline">
                            <?php esc_html_e( 'View', 'wpuf-pro' ); ?>
                            <svg class="!wpuf-w-3 !wpuf-h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                            </svg>
                        </a>
                    </div>
                    <div class="comment-content !wpuf-text-gray-700 !wpuf-leading-relaxed !wpuf-text-sm">
                        <p><?php echo wp_trim_words( $comment->comment_content, 30, '...' ); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
    <?php else : ?>
        <div class="!wpuf-flex !wpuf-flex-col !wpuf-items-center !wpuf-justify-center !wpuf-py-20 !wpuf-bg-gray-50 !wpuf-rounded-xl">
            <div class="!wpuf-mb-4">
                <svg class="!wpuf-w-24 !wpuf-h-24 !wpuf-text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                </svg>
            </div>
            <p class="!wpuf-text-xl !wpuf-font-medium !wpuf-text-gray-900 !wpuf-mb-2"><?php esc_html_e( 'No comments found', 'wpuf-pro' ); ?></p>
            <p class="!wpuf-text-base !wpuf-text-gray-500"><?php esc_html_e( 'This user hasn\'t posted any comments yet.', 'wpuf-pro' ); ?></p>
        </div>
    <?php endif; ?>
</div>