<?php
$user_id = $user->ID;

// Get user posts using WP_Query
$post_args = [
    'author'         => $user_id,
    'post_status'    => 'publish',
    'posts_per_page' => 10
];

$user_posts = new WP_Query( $post_args );
?>

<div class="wpuf-profile-section wpuf-posts-section !wpuf-mb-8">
    <h1 class="profile-section-heading !wpuf-text-2xl !wpuf-font-bold !wpuf-text-gray-900 !wpuf-mb-6">
        <?php esc_html_e( 'Posts', 'wpuf-pro' ); ?>
    </h1>
    
    <?php if ( $user_posts->have_posts() ) : ?>
        <div class="posts-table !wpuf-bg-gray-50 !wpuf-rounded-xl !wpuf-border !wpuf-border-gray-200 !wpuf-overflow-hidden">
            <!-- Table Header -->
            <div class="table-header !wpuf-bg-white !wpuf-border-b !wpuf-border-gray-200 !wpuf-h-[50px] !wpuf-flex !wpuf-items-center">
                <div class="!wpuf-grid !wpuf-grid-cols-12 !wpuf-gap-4 !wpuf-px-6 !wpuf-items-center !wpuf-w-full">
                    <div class="!wpuf-col-span-6 !wpuf-text-base !wpuf-font-normal !wpuf-text-blue-500 !wpuf-leading-none">
                        <?php esc_html_e( 'Post Title', 'wpuf-pro' ); ?>
                    </div>
                    <div class="!wpuf-col-span-3 !wpuf-text-base !wpuf-font-normal !wpuf-text-blue-500 !wpuf-leading-none">
                        <?php esc_html_e( 'Publish Date', 'wpuf-pro' ); ?>
                    </div>
                    <div class="!wpuf-col-span-3 !wpuf-text-base !wpuf-font-normal !wpuf-text-blue-500 !wpuf-text-right !wpuf-leading-none">
                        <?php esc_html_e( 'Action', 'wpuf-pro' ); ?>
                    </div>
                </div>
            </div>
            
            <!-- Table Body -->
            <div class="table-body !wpuf-bg-white">
                <?php while ( $user_posts->have_posts() ) : $user_posts->the_post(); ?>
                <div class="table-row !wpuf-border-b !wpuf-border-gray-100 last:!wpuf-border-b-0 hover:!wpuf-bg-blue-50 !wpuf-transition-colors !wpuf-duration-150 !wpuf-h-[58px] !wpuf-flex !wpuf-items-center">
                    <div class="!wpuf-grid !wpuf-grid-cols-12 !wpuf-gap-4 !wpuf-px-6 !wpuf-items-center !wpuf-w-full">
                        <div class="!wpuf-col-span-6">
                            <div class="!wpuf-text-base !wpuf-font-normal !wpuf-text-gray-900 !wpuf-leading-none">
                                <?php echo wp_trim_words( get_the_title(), 10 ); ?>
                            </div>
                        </div>
                        <div class="!wpuf-col-span-3">
                            <div class="!wpuf-text-base !wpuf-font-normal !wpuf-text-gray-600 !wpuf-leading-none">
                                <?php echo esc_html( get_the_date( 'M j, Y' ) ); ?>
                            </div>
                        </div>
                        <div class="!wpuf-col-span-3 !wpuf-text-right">
                            <a href="<?php echo get_permalink(); ?>" 
                               target="_blank"
                               class="!wpuf-inline-flex !wpuf-items-center !wpuf-gap-1 !wpuf-text-base !wpuf-font-normal !wpuf-text-gray-700 hover:!wpuf-text-blue-500 !wpuf-transition-colors !wpuf-no-underline">
                                <?php esc_html_e( 'Post Link', 'wpuf-pro' ); ?>
                                <svg class="!wpuf-w-4 !wpuf-h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>

    <?php else : ?>
        <div class="!wpuf-flex !wpuf-flex-col !wpuf-items-center !wpuf-justify-center !wpuf-py-20 !wpuf-bg-gray-50 !wpuf-rounded-xl">
            <div class="!wpuf-mb-4">
                <svg class="!wpuf-w-24 !wpuf-h-24 !wpuf-text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
                </svg>
            </div>
            <p class="!wpuf-text-xl !wpuf-font-medium !wpuf-text-gray-900 !wpuf-mb-2"><?php esc_html_e( 'No posts found', 'wpuf-pro' ); ?></p>
            <p class="!wpuf-text-base !wpuf-text-gray-500"><?php esc_html_e( 'This user hasn\'t published any posts yet.', 'wpuf-pro' ); ?></p>
        </div>
    <?php endif; ?>
</div>

<?php 
wp_reset_postdata(); 
?>