<?php
$user_id = $user->ID;

// Get current page
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

// Get user posts using WP_Query
$post_args = [
    'author'         => $user_id,
    'post_status'    => 'publish',
    'posts_per_page' => 10,
    'paged'          => $paged
];

$user_posts = new WP_Query( $post_args );
?>
<div class="wpuf-ud-post-list">
    <h3 class="profile-section-heading"><?php esc_html_e( 'All Posts', 'wpuf-pro' ); ?></h3>
    
    <?php if ( $user_posts->have_posts() ) : ?>
        <table class="user-post-list-table">
            <thead>
                <tr>
                    <th><?php esc_attr_e( 'Post Title', 'wpuf-pro' ); ?></th>
                    <th><?php esc_attr_e( 'Publish Date', 'wpuf-pro' ); ?></th>
                    <th><?php esc_attr_e( 'Details', 'wpuf-pro' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php while ( $user_posts->have_posts() ) : $user_posts->the_post(); ?>
                <tr>
                    <td class="avatar-column">
                        <div class="image">
                            <?php if ( has_post_thumbnail() ) : ?>
                                <img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'thumbnail' ); ?>" width="32" height="32">
                            <?php else : ?>
                                <img src="<?php echo WPUF_ASSET_URI . '/images/no-image.png'; ?>" width="32" height="32">
                            <?php endif; ?>
                        </div>
                        <div class="post-description">
                            <p><?php echo wp_trim_words( get_the_title(), 6 ); ?></p>
                        </div>
                    </td>
                    <td>
                        <?php echo esc_attr( get_the_date() ); ?>
                    </td>
                    <td>
                        <a href="<?php echo get_permalink(); ?>">
                            <?php esc_html_e( 'View Post', 'wpuf-pro' ); ?> &rarr;
                        </a>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        
        <?php
        // Add pagination if there are multiple pages
        if ( $user_posts->max_num_pages > 1 ) :
            // Setup pagination data
            $pagination = [
                'total_pages' => $user_posts->max_num_pages,
                'current_page' => $paged,
                'per_page' => 10,
                'total_items' => $user_posts->found_posts
            ];
            
            // Flag to indicate this is profile pagination
            $is_profile = true;
            
            // Get current URL and preserve tab parameter
            $current_url = ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
            $parsed_url = wp_parse_url( $current_url );
            $base_url = $parsed_url['path'] ?? '';
            
            // Parse existing query args and add tab parameter
            $query_args = [];
            if ( ! empty( $parsed_url['query'] ) ) {
                parse_str( $parsed_url['query'], $query_args );
            }
            
            // Force tab parameter to maintain current tab
            $query_args['tab'] = 'posts';
            
            // Include pagination template
            include WPUF_UD_TEMPLATES . '/shortcodes/directory/template-parts/pagination-shortcode.php';
        endif;
        ?>
        
    <?php else : ?>
        <p><?php esc_html_e( 'No posts found', 'wpuf-pro' ); ?></p>
    <?php endif; ?>
</div>
<?php 
wp_reset_postdata(); 
?>