<?php
/**
 * User Avatar Block Template
 *
 * @since 4.2.0
 *
 * @var WP_User $user User object
 * @var array $attributes Block attributes
 * @var string $content Block content
 * @var WP_Block $block Block instance
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! $user ) {
    return;
}

// Get dynamic styling from block attributes
$styling = wpuf_get_avatar_styling( $attributes, $user );

// Get avatar URL and display size
$avatar_size = isset( $attributes['avatarSize'] ) ? $attributes['avatarSize'] : 'medium';
$custom_size = isset( $attributes['customSize'] ) ? intval( $attributes['customSize'] ) : 150;
$fallback_type = isset( $attributes['fallbackType'] ) ? $attributes['fallbackType'] : 'initials';
$avatar_shape = isset( $attributes['avatarShape'] ) ? $attributes['avatarShape'] : 'circle';

// Calculate display size including custom size
$display_size = wpuf_ud_get_avatar_display_size( $avatar_size, $custom_size );

// Get avatar data with custom profile photo priority
$avatar_data = wpuf_ud_get_block_avatar_data( $user, $display_size, $fallback_type );
$avatar_url = $avatar_data['url'];
$avatar_type = $avatar_data['type'];
$avatar_alt = $avatar_data['alt'];

$initials = wpuf_ud_get_user_initials( $user );

// Get size and shape classes
$size_class = 'wpuf-avatar--' . $avatar_size;
$shape_class = 'wpuf-avatar--' . $avatar_shape;

// Get block wrapper attributes
$wrapper_attributes = wpuf_get_block_wrapper_attributes( $attributes, 'avatar', [
    'class' => 'wpuf-user-avatar',
    'data-user-id' => $user->ID,
] );

// Add custom size CSS variable if needed
$custom_style = '';
if ( $avatar_size === 'custom' ) {
    $custom_style = '--wpuf-avatar-size: ' . $custom_size . 'px;';
}

?>
<div <?php echo $wrapper_attributes; ?>>
    <div class="wpuf-avatar-container" <?php echo $custom_style ? 'style="' . esc_attr( $custom_style ) . '"' : ''; ?>>
        <?php if ( $avatar_type === 'custom' || $avatar_type === 'gravatar' ) : ?>
            <!-- Show avatar image with fallback -->
            <img src="<?php echo esc_url( $avatar_url ); ?>"
                 alt="<?php echo esc_attr( $avatar_alt ); ?>"
                 class="wpuf-avatar--image <?php echo esc_attr( $size_class . ' ' . $shape_class ); ?>"
                 onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';" />
            <!-- Fallback initials (hidden by default) -->
            <div class="wpuf-avatar--initials <?php echo esc_attr( $size_class . ' ' . $shape_class ); ?>" style="display: none;">
                <span class="wpuf-avatar-initials-text"><?php echo esc_html( $initials ); ?></span>
            </div>
        <?php else : ?>
            <!-- Show initials (no image available) -->
            <div class="wpuf-avatar--initials <?php echo esc_attr( $size_class . ' ' . $shape_class ); ?>">
                <span class="wpuf-avatar-initials-text"><?php echo esc_html( $initials ); ?></span>
            </div>
        <?php endif; ?>
    </div>
</div>
