<?php
/**
 * User Name Block Template
 *
 * @since 4.2.0
 *
 * @var WP_User $user User object
 * @var array $attributes Block attributes
 * @var string $content Block content
 * @var WP_Block $block Block instance
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! $user ) {
    return;
}

// Get block attributes with defaults
$name_format = $attributes['nameFormat'] ?? 'display_name';
$element_type = isset( $attributes['headingLevel'] ) ? $attributes['headingLevel'] : 'p';
$show_role = isset( $attributes['showRole'] ) ? $attributes['showRole'] : false;
$role_separator = isset( $attributes['roleSeparator'] ) ? $attributes['roleSeparator'] : ', ';

// Get formatted data
$formatted_name = wpuf_ud_get_formatted_name( $user, $name_format, '' );
$user_roles = wpuf_ud_get_user_roles_display( $user );

// Get block wrapper attributes (includes styling from block editor)
$wrapper_attributes = wpuf_get_block_wrapper_attributes( $attributes, 'name', [
    'class' => 'wpuf-user-name',
    'data-user-id' => $user->ID,
] );

?>
<div <?php echo $wrapper_attributes; ?>>
    <?php
    $content = $formatted_name;
    if ( $show_role && ! empty( $user_roles ) ) {
        $content .= $role_separator . implode( ', ', $user_roles );
    }
    ?>
    <<?php echo esc_attr( $element_type ); ?> class="wpuf-name-text">
        <?php echo esc_html( $content ); ?>
    </<?php echo esc_attr( $element_type ); ?>>
</div>
