<div class="panel-field-opt panel-field-opt-address">
    <label class="label-hr wpuf-mb-2">
        {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
    </label>
    <div
        v-for="(address, field) in editing_form_field.address">
        <div
            @click="toggle_show_details(field)"
            class="wpuf-flex wpuf-justify-between wpuf-py-2">
            <div class="wpuf-flex wpuf-items-center">
                <input
                    type="checkbox"
                    :class="builder_class_names('checkbox')"
                    :checked="address.checked"
                    @click="toggle_address_checked(field)"
                >
                <label class="wpuf-ml-1">
                    {{ i18n[field] }}
                </label>
            </div>
            <i class="fa fa-angle-down wpuf-text-lg"></i>
        </div>
        <div v-show="show_details[field]" class="wpuf-p-4 !wpuf-pt-0">
            <template v-if="'country_select' !== field">
                <div class="wpuf-mb-2 wpuf-flex">
                    <input
                        type="checkbox"
                        :name="field + '_required'"
                        :class="builder_class_names('checkbox')"
                        :checked="address.required"
                        @click="toggle_address_required(field)"
                    > <label :for="field + '_required'"><?php _e( 'Required', 'wpuf-pro' ); ?></label>
                </div>
                <label><?php _e( 'Label', 'wpuf-pro' ); ?></label>
                <div class="wpuf-mt-2">
                    <input type="text" :class="builder_class_names('text')" v-model="address.label">
                </div>
                <div class="wpuf-flex wpuf-justify-between wpuf-mt-4 wpuf-w-full">
                    <div class="default-item wpuf-mr-1 wpuf-w-1/2">
                        <label><?php _e( 'Default', 'wpuf-pro' ); ?></label>
                        <div class="wpuf-mt-2 wpuf-mr-2">
                            <input type="text" class="wpuf-w-full" :class="builder_class_names('text')" v-model="address.value">
                        </div>
                    </div>
                    <div class="placeholder-item wpuf-w-1/2">
                        <label><?php _e( 'Placeholder', 'wpuf-pro' ); ?></label>
                        <div class="wpuf-mt-2">
                            <input type="text" class="wpuf-w-full" :class="builder_class_names('text')" v-model="address.placeholder">
                        </div>
                    </div>
                </div>
            </template>
            <template v-else>
                <div class="wpuf-mb-2 wpuf-flex">
                    <input
                        type="checkbox"
                        :name="field + '_required'"
                        :class="builder_class_names('checkbox')"
                        :checked="address.required"
                        @click="toggle_address_required(field)"
                    > <label :for="field + '_required'"><?php _e( 'Required', 'wpuf-pro' ); ?></label>
                </div>

                <div v-show="show_details[field]" class="address-country-default address-input-fields">
                    <div class="wpuf-flex wpuf-mb-2">
                        <label
                            class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
                            <?php esc_html_e( 'Default Country', 'wpuf-pro' ); ?>
                        </label>
                    </div>
                    <select class="default-country" v-model="default_country">
                        <option value=""><?php esc_html_e( 'Select Country', 'wpuf-pro' ); ?></option>
                        <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
                    </select>
                    <div class="panel-field-opt-select country-list-selector-container">
                        <div class="wpuf-flex wpuf-items-center wpuf-mt-2">
                            <label class="label-title-block"><?php _e( 'Country List', 'wpuf-pro' ); ?></label>
                            <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
                        </div>
                        <div class="wpuf-flex wpuf-bg-gray-100 wpuf-w-full wpuf-rounded-lg wpuf-p-2">
                            <button
                                v-for="button in visibility_buttons"
                                type="button"
                                :class="[button.name === active_visibility ? 'wpuf-bg-white' : '' ]"
                                class="wpuf-nav-tab wpuf-py-2 wpuf-px-4 wpuf-text-base hover:wpuf-bg-white hover:wpuf-text-gray-800 hover:wpuf-rounded-md hover:wpuf-drop-shadow-sm focus:wpuf-shadow-none wpuf-mr-2 hover:wpuf-cursor-pointer wpuf-text-gray-800 wpuf-rounded-md wpuf-drop-shadow-sm wpuf-basis-1/3 wpuf-transition-all"
                                @click.prevent="set_visibility(button.name)"
                            >{{ button.title }}</button>
                        </div>

                        <select
                            v-show="'all' === active_visibility"
                            :class="['country-list-selector selectize-element-group', 'all' === active_visibility ? 'active' : '']"
                            disabled
                        >
                            <option value=""><?php _e( 'Select Countries', 'wpuf-pro' ); ?></option>
                        </select>

                        <select
                            v-show="'hide' === active_visibility"
                            :class="['country-list-selector selectize-element-group', 'hide' === active_visibility ? 'active' : '']"
                            v-model="country_in_hide_list"
                            data-visibility="hide"
                            multiple
                        >
                            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
                        </select>

                        <select
                            v-show="'show' === active_visibility"
                            :class="['country-list-selector selectize-element-group', 'show' === active_visibility ? 'active' : '']"
                            v-model="country_in_show_list"
                            data-visibility="show"
                            multiple
                        >
                            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
                        </select>
                    </div>
                </div>
            </template>
        </div>
    </div>
</div>
