<div
    v-if="wpuf_cond && wpuf_cond.condition_status"
    class="panel-field-opt panel-field-opt-conditional-logic">
    <label class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
        <?php _e( 'Conditional Logic', 'wpuf-pro' ); ?>
    </label>

    <ul class="list-inline wpuf-mt-3">
        <li>
            <label class="wpuf-block text-sm/6 wpuf-font-medium wpuf-text-gray-900">
                <input
                    v-model="wpuf_cond.condition_status"
                    type="radio"
                    value="yes"
                    :class="builder_class_names('radio')"> <?php _e( 'Yes', 'wpuf-pro' ); ?>
            </label>
        </li>

        <li>
            <label class="wpuf-block text-sm/6 wpuf-font-medium wpuf-text-gray-900">
                <input
                    v-model="wpuf_cond.condition_status"
                    type="radio"
                    value="no"
                    :class="builder_class_names('radio')"> <?php _e( 'No', 'wpuf-pro' ); ?>
            </label>
        </li>
    </ul>

    <div v-if="'yes' === wpuf_cond.condition_status" class="condiotional-logic-container ">
        <p class="wpuf-text-sm wpuf-leading-6 wpuf-mb-4">
            <span class="wpuf-mb-3 wpuf-block">
            <?php
            printf(
                __( 'Show this field when%s%s%sof these rules are met%s', 'wpuf-pro' ),
                '</span>',
                '<field-dropdown
                container_class="wpuf-w-1/3"
                dropdown_class="wpuf-py-[10px] wpuf-px-[14px] wpuf-font-medium"
                :options="rule_options" @change="update_cond_logic" :default_option="wpuf_cond.cond_logic" />',
                '<span class="wpuf-ml-3">',
                '</span>'
            );

            ?>
        </p>
        <ul class="condiotional-logic-repeater">
            <li v-for="(condition, index) in conditions" class="clearfix">
                <div class="cond-field">
                    <select
                        v-model="condition.name"
                        :class="builder_class_names('dropdown')"
                        class="wpuf-mb-2"
                        @change="on_change_cond_field(index, $event)">
                        <option value=""><?php esc_html_e( '- Select -', 'wpuf-pro' ); ?></option>
                        <option
                            v-for="(dep_field, index) in dependencies"
                            :value="dep_field.name"
                            :data-type="dep_field.input_type"
                            :data-field-type="dep_field.type"
                            :key="index"
                        >{{ dep_field.label }}</option>
                    </select>
                </div>

                <div class="cond-operator">
                    <select
                        v-model="condition.operator"
                        :class="builder_class_names('dropdown')"
                        class="wpuf-mb-2">
                        <option
                            v-for="(operator, index) in get_cond_operators(condition.input_type)"
                            :value="operator.value"
                            :key="index">
                                {{ operator.label }}
                        </option>
                    </select>
                </div>

                <div class="cond-option">
                    <input
                        v-model="condition.option"
                        v-if="show_textfield(condition.input_type)"
                        :class="builder_class_names('text')"
                        type="text"
                        :disabled="is_disabled(condition.operator)"
                    >
                    <select
                        v-model="condition.option"
                        v-if="show_dropdown(condition.input_type)"
                        :disabled="is_disabled(condition.operator)"
                        @change="on_change_options_field(index, $event)"
                        :class="builder_class_names('dropdown')">
                        <option
                            v-for="cond_option in get_cond_options(condition.name)"
                            :value="cond_option.opt_name"
                            :data-option-title="cond_option.opt_title"
                        >
                            {{ cond_option.opt_title }}
                        </option>
                    </select>
                </div>

                <div class="cond-action-btns wpuf-flex wpuf-my-2">
                    <span class="wpuf-repeater-add hover:wpuf-cursor-pointer" @click="add_condition">
                        <img src="<?php echo WPUF_ASSET_URI . '/images/plus-circle-green.svg' ?>" alt="">
                    </span>
                    <span class="wpuf-repeater-remove hover:wpuf-cursor-pointer" @click="delete_condition(index)">
                        <img src="<?php echo WPUF_ASSET_URI . '/images/minus-circle-green.svg' ?>" alt="">
                    </span>
                </div>
            </li>
        </ul>
    </div>
</div>
