<div v-if="met_dependencies">
    <div class="panel-field-opt panel-field-opt-select">
        <div class="wpuf-flex">
            <label
                class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
                <?php _e( 'Default Country', 'wpuf-pro' ); ?>
            </label>
        </div>
        <select class="default-country" v-model="default_country">
            <option value=""><?php _e( 'Select Country', 'wpuf-pro' ); ?></option>
            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
        </select>
    </div>

    <div class="panel-field-opt panel-field-opt-select">
        <div class="wpuf-flex wpuf-items-center">
            <label class="label-title-block"><?php _e( 'Country List', 'wpuf-pro' ); ?></label>
            <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
        </div>
        <div class="wpuf-flex wpuf-bg-gray-100 wpuf-w-full wpuf-rounded-lg wpuf-p-2">
            <button
                v-for="button in visibility_buttons"
                type="button"
                :class="[button.name === active_visibility ? 'wpuf-bg-white' : '' ]"
                class="wpuf-nav-tab wpuf-py-2 wpuf-px-4 wpuf-text-base hover:wpuf-bg-white hover:wpuf-text-gray-800 hover:wpuf-rounded-md hover:wpuf-drop-shadow-sm focus:wpuf-shadow-none wpuf-mr-2 hover:wpuf-cursor-pointer wpuf-text-gray-800 wpuf-rounded-md wpuf-drop-shadow-sm wpuf-basis-1/3 wpuf-transition-all"
                @click.prevent="set_visibility(button.name)"
            >{{ button.title }}</button>
        </div>

        <select
            v-show="'all' === active_visibility"
            :class="['country-list-selector selectize-element-group', 'all' === active_visibility ? 'active' : '']"
            disabled
        >
            <option value=""><?php _e( 'Select Countries', 'wpuf-pro' ); ?></option>
        </select>

        <select
            v-show="'hide' === active_visibility"
            :class="['country-list-selector selectize-element-group', 'hide' === active_visibility ? 'active' : '']"
            v-model="country_in_hide_list"
            data-visibility="hide"
            multiple
        >
            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
        </select>

        <select
            v-show="'show' === active_visibility"
            :class="['country-list-selector selectize-element-group', 'show' === active_visibility ? 'active' : '']"
            v-model="country_in_show_list"
            data-visibility="show"
            multiple
        >
            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
        </select>
    </div>
</div>
