    <div class="wpuf-integration-conditional-logic-container">
        <div class="wpuf-my-4 wpuf-input-container">
            <div class="wpuf-flex wpuf-items-center">
                <label class="wpuf-flex wpuf-text-sm wpuf-text-gray-700 wpuf-my-2">
                    {{ label }}
                    <help-text :text="'Choose whether to apply conditions for ' + integrationName + ' integration'"></help-text>
                </label>
            </div>
            <div>
                <label style="margin-right: 2rem;">
                    <input
                        type="radio"
                        :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][condition_status]'"
                        value="yes"
                        v-model="condition_status"
                        class="wpuf-integrations-conditional-logic !wpuf-mr-2 wpuf-radio !wpuf-shadow-none checked:!wpuf-shadow-none focus:checked:!wpuf-shadow-primary !wpuf-border-gray-300 checked:!wpuf-border-primary checked:!wpuf-bg-primary before:checked:!wpuf-bg-white hover:checked:!wpuf-bg-primary focus:!wpuf-ring-transparent focus:checked:!wpuf-ring-transparent hover:checked:!wpuf-ring-transparent focus:checked:!wpuf-bg-primary focus:checked:!wpuf-shadow-none focus:wpuf-shadow-primary">
                    <?php _e( 'Yes', 'wpuf-pro' ); ?>
                </label>
                <label>
                    <input
                        type="radio"
                        :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][condition_status]'"
                        value="no"
                        v-model="condition_status"
                        class="wpuf-integrations-conditional-logic !wpuf-mr-2 wpuf-radio !wpuf-shadow-none checked:!wpuf-shadow-none focus:checked:!wpuf-shadow-primary !wpuf-border-gray-300 checked:!wpuf-border-primary checked:!wpuf-bg-primary before:checked:!wpuf-bg-white hover:checked:!wpuf-bg-primary focus:!wpuf-ring-transparent focus:checked:!wpuf-ring-transparent hover:checked:!wpuf-ring-transparent focus:checked:!wpuf-bg-primary focus:checked:!wpuf-shadow-none focus:wpuf-shadow-primary">
                    <?php _e( 'No', 'wpuf-pro' ); ?>
                </label>
            </div>
        </div>

        <div v-if="condition_status === 'yes'" class="wpuf-conditional-logic-settings wpuf-my-4">
            <p class="wpuf-text-sm wpuf-leading-6 wpuf-mb-4">
                <span class="wpuf-mb-3 wpuf-block">
                    <?php
                    printf(
                        __( 'Apply %s integration when%s%s%sof these rules are met%s', 'wpuf-pro' ),
                        '{{ integrationName }}',
                        '</span>',
                        '<select v-model="cond_logic" class="wpuf-no-selectize wpuf-py-[10px] wpuf-px-[14px] wpuf-font-medium wpuf-w-1/3">
                            <option v-for="option in rule_options" :value="option.value" :key="option.value">{{ option.label }}</option>
                        </select>',
                        '<span class="wpuf-ml-3">',
                        '</span>'
                    );
                    ?>
            </p>

            <div class="wpuf-conditional-logic-rules">
                <div v-for="(condition, index) in conditions" :key="condition.id" class="wpuf-conditional-rule wpuf-grid wpuf-grid-cols-7 wpuf-gap-4 wpuf-mb-4">
                    <!-- Field Selection -->
                    <div class="cond-field wpuf-col-span-2">
                        <select
                            v-model="condition.name"
                            @change="on_change_cond_field(index)"
                            class="wpuf-no-selectize wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent">
                            <option value=""><?php esc_html_e( '- Select Field -', 'wpuf-pro' ); ?></option>
                            <option
                                v-for="field in conditional_fields"
                                :value="field.name"
                                :key="field.name">
                                {{ field.label }}
                            </option>
                        </select>
                    </div>

                    <!-- Operator Selection -->
                    <div class="cond-operator wpuf-col-span-2">
                        <select
                            v-model="condition.operator"
                            @change="on_change_cond_operator(index)"
                            class="wpuf-no-selectize wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent">
                            <option
                                v-for="operator in get_cond_operators(condition.name)"
                                :value="operator.value"
                                :key="operator.value">
                                {{ operator.label }}
                            </option>
                        </select>
                    </div>

                    <!-- Value Selection -->
                    <div class="cond-option wpuf-relative wpuf-col-span-2">
                        <!-- Text Input -->
                        <input
                            v-if="show_textfield(condition.name)"
                            v-model="condition.option"
                            @input="on_change_cond_option(index)"
                            type="text"
                            :disabled="is_disabled(condition.operator)"
                            class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent disabled:wpuf-bg-gray-100 disabled:wpuf-cursor-not-allowed">

                        <!-- Dropdown Selection -->
                        <select
                            v-if="show_dropdown(condition.name)"
                            v-model="condition.option"
                            @change="on_change_cond_option(index)"
                            :disabled="is_disabled(condition.operator)"
                            class="wpuf-no-selectize wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent disabled:wpuf-bg-gray-100 disabled:wpuf-cursor-not-allowed">
                            <option value=""><?php esc_html_e( '- Select Option -', 'wpuf-pro' ); ?></option>
                            <option
                                v-for="option in get_cond_options(condition.name)"
                                :value="option.value"
                                :key="option.value">
                                {{ option.label }}
                            </option>
                        </select>
                    </div>

                    <!-- Action Buttons -->
                    <div class="cond-action-btns wpuf-flex wpuf-my-2">
                        <span
                            v-if="conditions.length > 1"
                            @click="delete_condition(index)"
                            class="wpuf-repeater-remove hover:wpuf-cursor-pointer wpuf-mr-2">
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                fill="none"
                                viewBox="0 0 24 24"
                                stroke-width="1.5"
                                stroke="currentColor"
                                class="wpuf-size-6 wpuf-border wpuf-rounded-2xl wpuf-border-gray-400 hover:wpuf-border-primary wpuf-p-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h14" />
                            </svg>
                        </span>
                        <span
                            v-if="conditions.length === index + 1"
                            @click="add_condition"
                            class="wpuf-repeater-add hover:wpuf-cursor-pointer">
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                fill="none"
                                viewBox="0 0 24 24"
                                stroke-width="1.5"
                                stroke="currentColor"
                                class="wpuf-ml-1 wpuf-size-6 wpuf-border wpuf-rounded-2xl wpuf-border-gray-400 wpuf-p-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                                </svg>
                        </span>
                    </div>
                </div>
            </div>

            <div class="description wpuf-text-sm wpuf-text-gray-600 wpuf-mt-2">
                <?php printf( __( '%s integration will run if the above conditions are met.', 'wpuf-pro' ), '{{ integrationName | capitalize }}' ); ?>
            </div>
        </div>

        <!-- Hidden inputs for form submission -->
        <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][condition_status]'" :value="condition_status">
        <template v-if="condition_status === 'yes'">
            <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][cond_logic]'" :value="cond_logic">
            <template v-for="(condition, index) in conditions">
                <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][conditions][' + index + '][name]'" :value="condition.name">
                <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][conditions][' + index + '][operator]'" :value="condition.operator">
                <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][conditions][' + index + '][option]'" :value="condition.option">
            </template>
        </template>
    </div>
