<script type="text/x-template" id="tmpl-wpuf-field-address">
<div class="panel-field-opt panel-field-opt-address">
    <label class="label-hr wpuf-mb-2">
        {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
    </label>
    <div
        v-for="(address, field) in editing_form_field.address">
        <div
            @click="toggle_show_details(field)"
            class="wpuf-flex wpuf-justify-between wpuf-py-2">
            <div class="wpuf-flex wpuf-items-center">
                <input
                    type="checkbox"
                    :class="builder_class_names('checkbox')"
                    :checked="address.checked"
                    @click="toggle_address_checked(field)"
                >
                <label class="wpuf-ml-1">
                    {{ i18n[field] }}
                </label>
            </div>
            <i class="fa fa-angle-down wpuf-text-lg"></i>
        </div>
        <div v-show="show_details[field]" class="wpuf-p-4 !wpuf-pt-0">
            <template v-if="'country_select' !== field">
                <div class="wpuf-mb-2 wpuf-flex">
                    <input
                        type="checkbox"
                        :name="field + '_required'"
                        :class="builder_class_names('checkbox')"
                        :checked="address.required"
                        @click="toggle_address_required(field)"
                    > <label :for="field + '_required'"><?php _e( 'Required', 'wpuf-pro' ); ?></label>
                </div>
                <label><?php _e( 'Label', 'wpuf-pro' ); ?></label>
                <div class="wpuf-mt-2">
                    <input type="text" :class="builder_class_names('text')" v-model="address.label">
                </div>
                <div class="wpuf-flex wpuf-justify-between wpuf-mt-4 wpuf-w-full">
                    <div class="default-item wpuf-mr-1 wpuf-w-1/2">
                        <label><?php _e( 'Default', 'wpuf-pro' ); ?></label>
                        <div class="wpuf-mt-2 wpuf-mr-2">
                            <input type="text" class="wpuf-w-full" :class="builder_class_names('text')" v-model="address.value">
                        </div>
                    </div>
                    <div class="placeholder-item wpuf-w-1/2">
                        <label><?php _e( 'Placeholder', 'wpuf-pro' ); ?></label>
                        <div class="wpuf-mt-2">
                            <input type="text" class="wpuf-w-full" :class="builder_class_names('text')" v-model="address.placeholder">
                        </div>
                    </div>
                </div>
            </template>
            <template v-else>
                <div class="wpuf-mb-2 wpuf-flex">
                    <input
                        type="checkbox"
                        :name="field + '_required'"
                        :class="builder_class_names('checkbox')"
                        :checked="address.required"
                        @click="toggle_address_required(field)"
                    > <label :for="field + '_required'"><?php _e( 'Required', 'wpuf-pro' ); ?></label>
                </div>

                <div v-show="show_details[field]" class="address-country-default address-input-fields">
                    <div class="wpuf-flex wpuf-mb-2">
                        <label
                            class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
                            <?php esc_html_e( 'Default Country', 'wpuf-pro' ); ?>
                        </label>
                    </div>
                    <select class="default-country" v-model="default_country">
                        <option value=""><?php esc_html_e( 'Select Country', 'wpuf-pro' ); ?></option>
                        <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
                    </select>
                    <div class="panel-field-opt-select country-list-selector-container">
                        <div class="wpuf-flex wpuf-items-center wpuf-mt-2">
                            <label class="label-title-block"><?php _e( 'Country List', 'wpuf-pro' ); ?></label>
                            <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
                        </div>
                        <div class="wpuf-flex wpuf-bg-gray-100 wpuf-w-full wpuf-rounded-lg wpuf-p-2">
                            <button
                                v-for="button in visibility_buttons"
                                type="button"
                                :class="[button.name === active_visibility ? 'wpuf-bg-white' : '' ]"
                                class="wpuf-nav-tab wpuf-py-2 wpuf-px-4 wpuf-text-base hover:wpuf-bg-white hover:wpuf-text-gray-800 hover:wpuf-rounded-md hover:wpuf-drop-shadow-sm focus:wpuf-shadow-none wpuf-mr-2 hover:wpuf-cursor-pointer wpuf-text-gray-800 wpuf-rounded-md wpuf-drop-shadow-sm wpuf-basis-1/3 wpuf-transition-all"
                                @click.prevent="set_visibility(button.name)"
                            >{{ button.title }}</button>
                        </div>

                        <select
                            v-show="'all' === active_visibility"
                            :class="['country-list-selector selectize-element-group', 'all' === active_visibility ? 'active' : '']"
                            disabled
                        >
                            <option value=""><?php _e( 'Select Countries', 'wpuf-pro' ); ?></option>
                        </select>

                        <select
                            v-show="'hide' === active_visibility"
                            :class="['country-list-selector selectize-element-group', 'hide' === active_visibility ? 'active' : '']"
                            v-model="country_in_hide_list"
                            data-visibility="hide"
                            multiple
                        >
                            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
                        </select>

                        <select
                            v-show="'show' === active_visibility"
                            :class="['country-list-selector selectize-element-group', 'show' === active_visibility ? 'active' : '']"
                            v-model="country_in_show_list"
                            data-visibility="show"
                            multiple
                        >
                            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
                        </select>
                    </div>
                </div>
            </template>
        </div>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-conditional-logic">
<div
    v-if="wpuf_cond && wpuf_cond.condition_status"
    class="panel-field-opt panel-field-opt-conditional-logic">
    <label class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
        <?php _e( 'Conditional Logic', 'wpuf-pro' ); ?>
    </label>

    <ul class="list-inline wpuf-mt-3">
        <li>
            <label class="wpuf-block text-sm/6 wpuf-font-medium wpuf-text-gray-900">
                <input
                    v-model="wpuf_cond.condition_status"
                    type="radio"
                    value="yes"
                    :class="builder_class_names('radio')"> <?php _e( 'Yes', 'wpuf-pro' ); ?>
            </label>
        </li>

        <li>
            <label class="wpuf-block text-sm/6 wpuf-font-medium wpuf-text-gray-900">
                <input
                    v-model="wpuf_cond.condition_status"
                    type="radio"
                    value="no"
                    :class="builder_class_names('radio')"> <?php _e( 'No', 'wpuf-pro' ); ?>
            </label>
        </li>
    </ul>

    <div v-if="'yes' === wpuf_cond.condition_status" class="condiotional-logic-container ">
        <p class="wpuf-text-sm wpuf-leading-6 wpuf-mb-4">
            <span class="wpuf-mb-3 wpuf-block">
            <?php
            printf(
                __( 'Show this field when%s%s%sof these rules are met%s', 'wpuf-pro' ),
                '</span>',
                '<field-dropdown
                container_class="wpuf-w-1/3"
                dropdown_class="wpuf-py-[10px] wpuf-px-[14px] wpuf-font-medium"
                :options="rule_options" @change="update_cond_logic" :default_option="wpuf_cond.cond_logic" />',
                '<span class="wpuf-ml-3">',
                '</span>'
            );

            ?>
        </p>
        <ul class="condiotional-logic-repeater">
            <li v-for="(condition, index) in conditions" class="clearfix">
                <div class="cond-field">
                    <select
                        v-model="condition.name"
                        :class="builder_class_names('dropdown')"
                        class="wpuf-mb-2"
                        @change="on_change_cond_field(index, $event)">
                        <option value=""><?php esc_html_e( '- Select -', 'wpuf-pro' ); ?></option>
                        <option
                            v-for="(dep_field, index) in dependencies"
                            :value="dep_field.name"
                            :data-type="dep_field.input_type"
                            :data-field-type="dep_field.type"
                            :key="index"
                        >{{ dep_field.label }}</option>
                    </select>
                </div>

                <div class="cond-operator">
                    <select
                        v-model="condition.operator"
                        :class="builder_class_names('dropdown')"
                        class="wpuf-mb-2">
                        <option
                            v-for="(operator, index) in get_cond_operators(condition.input_type)"
                            :value="operator.value"
                            :key="index">
                                {{ operator.label }}
                        </option>
                    </select>
                </div>

                <div class="cond-option">
                    <input
                        v-model="condition.option"
                        v-if="show_textfield(condition.input_type)"
                        :class="builder_class_names('text')"
                        type="text"
                        :disabled="is_disabled(condition.operator)"
                    >
                    <select
                        v-model="condition.option"
                        v-if="show_dropdown(condition.input_type)"
                        :disabled="is_disabled(condition.operator)"
                        @change="on_change_options_field(index, $event)"
                        :class="builder_class_names('dropdown')">
                        <option
                            v-for="cond_option in get_cond_options(condition.name)"
                            :value="cond_option.opt_name"
                            :data-option-title="cond_option.opt_title"
                        >
                            {{ cond_option.opt_title }}
                        </option>
                    </select>
                </div>

                <div class="cond-action-btns wpuf-flex wpuf-my-2">
                    <span class="wpuf-repeater-add hover:wpuf-cursor-pointer" @click="add_condition">
                        <img src="<?php echo WPUF_ASSET_URI . '/images/plus-circle-green.svg' ?>" alt="">
                    </span>
                    <span class="wpuf-repeater-remove hover:wpuf-cursor-pointer" @click="delete_condition(index)">
                        <img src="<?php echo WPUF_ASSET_URI . '/images/minus-circle-green.svg' ?>" alt="">
                    </span>
                </div>
            </li>
        </ul>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-country-list">
<div v-if="met_dependencies">
    <div class="panel-field-opt panel-field-opt-select">
        <div class="wpuf-flex">
            <label
                class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
                <?php _e( 'Default Country', 'wpuf-pro' ); ?>
            </label>
        </div>
        <select class="default-country" v-model="default_country">
            <option value=""><?php _e( 'Select Country', 'wpuf-pro' ); ?></option>
            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
        </select>
    </div>

    <div class="panel-field-opt panel-field-opt-select">
        <div class="wpuf-flex wpuf-items-center">
            <label class="label-title-block"><?php _e( 'Country List', 'wpuf-pro' ); ?></label>
            <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
        </div>
        <div class="wpuf-flex wpuf-bg-gray-100 wpuf-w-full wpuf-rounded-lg wpuf-p-2">
            <button
                v-for="button in visibility_buttons"
                type="button"
                :class="[button.name === active_visibility ? 'wpuf-bg-white' : '' ]"
                class="wpuf-nav-tab wpuf-py-2 wpuf-px-4 wpuf-text-base hover:wpuf-bg-white hover:wpuf-text-gray-800 hover:wpuf-rounded-md hover:wpuf-drop-shadow-sm focus:wpuf-shadow-none wpuf-mr-2 hover:wpuf-cursor-pointer wpuf-text-gray-800 wpuf-rounded-md wpuf-drop-shadow-sm wpuf-basis-1/3 wpuf-transition-all"
                @click.prevent="set_visibility(button.name)"
            >{{ button.title }}</button>
        </div>

        <select
            v-show="'all' === active_visibility"
            :class="['country-list-selector selectize-element-group', 'all' === active_visibility ? 'active' : '']"
            disabled
        >
            <option value=""><?php _e( 'Select Countries', 'wpuf-pro' ); ?></option>
        </select>

        <select
            v-show="'hide' === active_visibility"
            :class="['country-list-selector selectize-element-group', 'hide' === active_visibility ? 'active' : '']"
            v-model="country_in_hide_list"
            data-visibility="hide"
            multiple
        >
            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
        </select>

        <select
            v-show="'show' === active_visibility"
            :class="['country-list-selector selectize-element-group', 'show' === active_visibility ? 'active' : '']"
            v-model="country_in_show_list"
            data-visibility="show"
            multiple
        >
            <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
        </select>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-dropdown">
<div
    :class="[container_class, is_bordered ? 'wpuf-border wpuf-border-gray-300 wpuf-shadow-sm' : '']"
    class="wpuf-dropdown wpuf-dropdown-bottom wpuf-dropdown-end wpuf-relative wpuf-rounded-[6px]">
    <div
        tabindex="0"
        role="button"
        @click="is_open = !is_open"
        :class="placeholder_class"
        class="wpuf-flex wpuf-justify-between wpuf-items-center wpuf-text-gray-700 wpuf-px-2 wpuf-py-1">
        {{ selected }}
        <i
            v-if="show_icon"
            :class="is_open ? 'fa fa-angle-up' : 'fa fa-angle-down'"
            class="form-switcher-arrow wpuf-ml-2"></i>
    </div>
    <ul tabindex="0"
        v-if="is_open"
        :class="dropdown_class"
        class="wpuf-absolute wpuf-dropdown-content wpuf-menu !wpuf-p-0 wpuf-rounded-md wpuf-z-[1] wpuf-w-52 wpuf-shadow wpuf-bg-white wpuf-left-0 !wpuf-top-8">
        <li v-for="option in options" :class="dropdown_item_class">
            <a
                @click="selectOption(option.value); is_open = false; $emit('change', option.value)"
                :class="dropdown_link_class"
                class="wpuf-block wpuf-rounded-none wpuf-font-medium wpuf-text-left wpuf-px-4 wpuf-py-2 !wpuf-text-sm wpuf-text-gray-700 hover:wpuf-bg-gray-100 hover:wpuf-text-gray-900 focus:wpuf-shadow-none focus:wpuf-outline-none">
                {{ option.label }}
            </a>
        </li>
    </ul>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-gmap-set-position">
<div>
    <label class="label-hr margin-bottom-10">
        <?php _e( 'Map Settings', 'wpuf-pro' ); ?>
    </label>

    <p>
        <em><?php _e( 'Set default co-ordinate and zoom level', 'wpuf-pro' ); ?></em>
    </p>

    <input class="wpuf-google-map-search" type="text" placeholder="<?php _e( 'Search address', 'wpuf-pro' ); ?>">
    <div class="wpuf-field-google-map"></div>

    <div class="panel-field-opt panel-field-opt-checkbox">
        <ul>
            <li class="wpuf-mt-2">
                <label>
                    <input
                        type="checkbox"
                        :class="builder_class_names('checkbox')"
                        :checked="'yes' === editing_form_field.address"
                        @click="toggle_checkbox_field('address')"
                    > <?php _e( 'Show address search box', 'wpuf-pro' ); ?>
                </label>
            </li>
        </ul>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-math-captcha">
<div v-if="met_dependencies" class="panel-field-opt panel-field-opt-text">
    <label>
        {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>

        <input
            v-if="option_field.variation && 'number' === option_field.variation"
            type="number"
            v-model="value"
            @focusout="on_focusout"
            @keyup="on_keyup"
        >

        <input
            v-if="!option_field.variation"
            type="text"
            v-model="value"
            @focusout="on_focusout"
            @keyup="on_keyup"
        >
    </label>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-option-data-price">
<div class="panel-field-opt panel-field-opt-text">
    <div class="wpuf-flex">
        <label class="wpuf-font-sm wpuf-text-gray-700">
            {{ option_field.title }}
            <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
        </label>
    </div>
    <div class="wpuf-mt-2 wpuf-flex">
        <label class="wpuf-block text-sm/6 wpuf-font-medium wpuf-text-gray-700">
            <input
                type="checkbox"
                v-model="show_value"
                :class="builder_class_names('checkbox')"
                class="!wpuf-mr-2" />
            <?php esc_attr_e( 'Show values', 'wpuf-pro' ); ?>
        </label>
        <label class="wpuf-block text-sm/6 wpuf-font-medium wpuf-text-gray-700 wpuf-ml-8">
            <input
                type="checkbox"
                v-model="sync_value"
                :class="builder_class_names('checkbox')"
                class="!wpuf-mr-2" />
            <?php esc_attr_e( 'Sync values', 'wpuf-pro' ); ?>
        </label>
    </div>

    <div class="wpuf-mt-4">
        <span class="wpuf-text-[14px] wpuf-text-gray-700 wpuf-font-medium"><?php esc_attr_e( 'Label, Values & Prices', 'wpuf-pro' ); ?></span>
        <table class="option-field-option-chooser">
            <tbody>
                <tr
                v-for="(option, index) in options"
                :key="option.id"
                :data-index="index"
                class="option-field-option wpuf-flex wpuf-justify-start wpuf-items-center">
                    <td class="wpuf-flex wpuf-items-center">
                        <input
                            v-if="option_field.is_multiple"
                            type="checkbox"
                            :value="option.value"
                            v-model="selected"
                            :class="builder_class_names('checkbox')"
                        >
                        <input
                            v-else
                            type="radio"
                            :value="option.value"
                            v-model="selected"
                            class="!wpuf-mt-0"
                            :class="builder_class_names('radio')"
                        >
                        <i class="fa fa-bars sort-handler hover:!wpuf-cursor-move wpuf-text-gray-400 wpuf-ml-1"></i>
                    </td>
                    <td>
                        <input
                            :class="[builder_class_names('text'), '!wpuf-w-full']"
                            type="text"
                            v-model="option.label"
                            @input="set_option_label(index, option.label)"
                            placeholder="Label">
                    </td>
                    <td v-if="show_value">
                        <input
                            :class="[builder_class_names('text'), '!wpuf-w-full']"
                            type="text"
                            v-model="option.value"
                            placeholder="Value">
                    </td>
                    <td>
                        <input
                            :class="[builder_class_names('text'), '!wpuf-w-full']"
                            type="number"
                            step="0.01"
                            v-model="option.price"
                            placeholder="Price">
                    </td>
                    <td>
                        <div class="wpuf-flex wpuf-ml-2">
                            <div
                                @click="delete_option(index)"
                                class="action-buttons hover:wpuf-cursor-pointer">
                                <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    fill="none"
                                    viewBox="0 0 24 24"
                                    stroke-width="1.5"
                                    stroke="currentColor"
                                    class="wpuf-size-6 wpuf-border wpuf-rounded-2xl wpuf-border-gray-400 hover:wpuf-border-primary wpuf-p-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h14" />
                                </svg>
                            </div>
                            <div
                                v-if="index === options.length - 1"
                                @click="add_option"
                                class="plus-buttons hover:wpuf-cursor-pointer !wpuf-border-0">
                                <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    fill="none"
                                    viewBox="0 0 24 24"
                                    stroke-width="1.5"
                                    stroke="currentColor"
                                    class="wpuf-ml-1 wpuf-size-6 wpuf-border wpuf-rounded-2xl wpuf-border-gray-400 wpuf-p-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                                </svg>
                            </div>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <a
        v-if="selected && ((!option_field.is_multiple && selected) || (option_field.is_multiple && selected.length > 0))"
        class="wpuf-inline-flex wpuf-items-center wpuf-gap-x-2 wpuf-rounded-md wpuf-px-3 wpuf-py-2 wpuf-text-sm wpuf-text-gray-700  hover:wpuf-text-gray-700 hover:wpuf-bg-gray-50 wpuf-ring-1 wpuf-ring-inset wpuf-ring-gray-300 wpuf-mt-4"
        href="#clear"
        @click.prevent="clear_selection">
        <?php esc_attr_e( 'Clear Selection', 'wpuf-pro' ); ?>
    </a>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-field-repeater-columns">
<div v-show="met_dependencies" class="panel-field-opt panel-field-opt-repeater-columns">

    <label>
        {{ option_field.title }} <help-text v-if="option_field.help_text" :text="option_field.help_text"></help-text>
    </label>

    <ul class="repeater-columns">
        <li v-for="(column, index) in editing_form_field.columns" class="clearfix repeater-single-column" :data-index="index">
            <div class="sorter">
                <i class="fa fa-bars sort-handler"></i>
            </div>

            <div class="input-container">
                <input type="text" v-model="editing_form_field.columns[index]">
            </div>

            <div class="action-buttons">
                    <i class="fa fa-plus-circle" @click="add_column"></i>
                    <i class="fa fa-minus-circle" @click="delete_column(index)"></i>
            </div>
        </li>
    </ul>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-field-step-start">
<div class="panel-field-opt panel-field-opt-multi-step">
    <div class="panel-field-opt panel-field-opt-text">
        <div class="wpuf-flex">
            <label
                class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
                <?php _e( 'Section Name', 'wpuf-pro' ); ?>
                <help-text text="<?php _e( 'Title', 'wpuf-pro' ); ?>"></help-text>
            </label>
        </div>
        <input
            type="text"
            v-model="editing_form_field.label"
            :class="builder_class_names('text')">
    </div>

    <div class="panel-field-opt panel-field-opt-text">
        <div class="wpuf-flex">
            <label
                class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
                <?php _e( 'Previous Button Text', 'wpuf-pro' ); ?>
                <help-text text="<?php _e( 'Previous Button Text', 'wpuf-pro' ); ?>"></help-text>
            </label>
        </div>
        <input
            type="text"
            v-model="editing_form_field.step_start.prev_button_text"
            :class="builder_class_names('text')">
    </div>

    <div class="panel-field-opt panel-field-opt-text">
        <div class="wpuf-flex">
            <label
                class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium">
            <?php _e( 'Next Button Text', 'wpuf-pro' ); ?> <help-text text="<?php _e( 'Next Button Text', 'wpuf-pro' ); ?>"></help-text>
        </label>
        </div>
        <input
            type="text"
            v-model="editing_form_field.step_start.next_button_text"
            :class="builder_class_names('text')">
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-action_hook">
<div class="wpuf-flex wpuf-items-center">
    <div class="wpuf-label"><?php _e( 'Action Hook', 'wpuf-pro' ); ?></div>

    <div class="wpuf-fields">
        <span v-if="!field.label"><em><?php _e( "hook name isn't set", 'wpuf-pro' ); ?></em></span>
        <span v-else>{{ field.label }}</span>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-address_field">
<div v-if="met_dependencies" class="panel-field-opt panel-field-opt-address-field wpuf-mb-0">
    <div class="wpuf-mt-2">
        <div v-for="(addr_field_details, addr_field) in field.address" :class="['wpuf-address-field', addr_field]" v-if="addr_field_details.checked">
            <div class="wpuf-sub-fields">
                <template v-if="'country_select' !== addr_field">
                    <input
                        v-if="'text' == addr_field_details.type"
                        type="text"
                        size="40"
                        :class="builder_class_names('textfield')"
                        :value="addr_field_details.value"
                        :placeholder="addr_field_details.placeholder"
                        :required="'checked' === addr_field_details.required"
                    >
                    <select
                        v-if="'select' == addr_field_details.type"
                        :class="builder_class_names('dropdown')"
                        name=""
                        id=""
                    >
                    <option value=""><?php _e( 'Select State', 'wpuf-pro' ); ?></option>
                    </select>
                </template>
                <template v-else>
                    <select
                        :required="'checked' === addr_field_details.required"
                        :class="builder_class_names('dropdown')"
                        v-model=default_country>
                        <option value=""><?php _e( 'Select Country', 'wpuf-pro' ); ?></option>
                        <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
                    </select>
                </template>
            </div>

            <label class="wpuf-form-sub-label">
                {{ addr_field_details.label }}
                <span v-if="'checked' === addr_field_details.required" class="required">*</span>
            </label>
        </div>
        <span v-if="field.help" class="wpuf-help" v-html="field.help"/>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-avatar">
<div class="wpuf-fields">
    <div :id="'wpuf-img_label-' + field.id + '-upload-container'">
        <div class="wpuf-attachment-upload-filelist" data-type="file" data-required="yes">
            <a class="button file-selector" href="#">
                <template v-if="field.button_label === ''">
                    <?php _e( 'Select Image', 'wpuf-pro' ); ?>
                </template>
                <template v-else>
                    {{ field.button_label }}
                </template>
            </a>
        </div>
    </div>

    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-cart_total">
<div class="wpuf-fields">
    <div class="wpuf-cart-total-display" style="font-size: 18px; font-weight: bold; padding: 15px; background: #f9f9f9; border: 1px solid #e0e0e0; border-radius: 4px;">
        <span class="wpuf-cart-total-label">{{ field.label }}:</span>
        <span class="wpuf-cart-total-amount">0.00</span>
    </div>
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-country_list_field">
<div class="wpuf-fields">
    <select v-model="default_country" :class="builder_class_names('dropdown')">
        <option value=""><?php _e( 'Select Country', 'wpuf-pro' ); ?></option>
        <option v-for="country in countries" :value="country.code">{{ country.name }}</option>
    </select>

    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-date_field">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.format"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-display_name">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-embed">
<div class="wpuf-fields">
    <input
        type="url"
        :class="builder_class_names('url')"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-facebook_url">
<div class="wpuf-fields">
    <!-- Icon next to label if enabled -->
    <div class="wpuf-social-input-wrapper" :class="field.width ? 'wpuf-' + field.width : 'wpuf-medium'">
        <input
            type="url"
            :class="builder_class_names('url')"
            :placeholder="field.placeholder"
            :value="field.default"
            :size="field.size"
        >
    </div>
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-file_upload">
<div class="wpuf-fields">
    <div :id="'wpuf-img_label-' + field.id + '-upload-container'">
        <div class="wpuf-attachment-upload-filelist" data-type="file" data-required="yes">
            <a
                :class="builder_class_names('upload_btn')"
                class="file-selector wpuf-inline-flex wpuf-items-center wpuf-gap-x-1.5"
                href="#">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="wpuf-size-5">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                </svg>

                <?php _e( 'Select Files', 'wpuf-pro' ); ?>
            </a>
        </div>
    </div>

    <p v-if="field.help" class="wpuf-mt-2 wpuf-mb-0 wpuf-text-sm wpuf-text-gray-500" v-html="field.help"></p>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-first_name">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help"></span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-gender_field">
<div class="wpuf-fields">
    <select
        :class="builder_class_names('dropdown')">
        <option v-if="field.first" value="">{{ field.first }}</option>
        <option value="male"><?php esc_html_e( 'Male', 'wpuf-pro' ); ?></option>
        <option value="female"><?php esc_html_e( 'Female', 'wpuf-pro' ); ?></option>
        <option value="non_binary"><?php esc_html_e( 'Non-binary', 'wpuf-pro' ); ?></option>
        <option value="prefer_not_say"><?php esc_html_e( 'Prefer not to say', 'wpuf-pro' ); ?></option>
    </select>
    <p v-if="field.help" class="wpuf-mt-2 wpuf-mb-0 wpuf-text-sm wpuf-text-gray-500" v-html="field.help"></p>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-google_map">
<div class="wpuf-fields">
    <?php if ( ! empty( wpuf_get_option( 'gmap_api_key', 'wpuf_general' ) ) ): ?>
    <div :class="['wpuf-form-google-map-container', 'yes' === field.address ? 'show-search-box': 'hide-search-box']">
        <input class="wpuf-google-map-search" type="text" placeholder="<?php _e( 'Search address', 'wpuf-pro' ); ?>">
        <div class="wpuf-form-google-map"></div>
    </div>
    <div :class="['wpuf-fields clearfix', field.directions ? 'has-directions-checkbox' : '']">
        <span v-if="field.directions" class="wpuf-directions-checkbox">
            <a class="btn btn-brand btn-sm" href="#" ><i class="fa fa-map-marker" aria-hidden="true"></i><?php _e( 'Directions »', 'wpuf-pro' ); ?></a>
        </span>
    </div>
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
    <?php else: ?>
        <p><?php esc_html_e( 'Please set Google Map API Key first in WPUF admin settings to use this Google Map field.', 'wpuf-pro' ); ?></p>
    <?php endif; ?>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-instagram_url">
<div class="wpuf-fields">
    <!-- Icon next to label if enabled -->
    <div class="wpuf-social-input-wrapper" :class="field.width ? 'wpuf-' + field.width : 'wpuf-medium'">
        <input
            type="url"
            :class="builder_class_names('url')"
            :placeholder="field.placeholder"
            :value="field.default"
            :size="field.size"
        >
    </div>
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-last_name">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help"> </span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-linkedin_url">
<div class="wpuf-fields">
    <!-- Icon next to label if enabled -->
    <div class="wpuf-social-input-wrapper" :class="field.width ? 'wpuf-' + field.width : 'wpuf-medium'">
        <input
            type="url"
            :class="builder_class_names('url')"
            :placeholder="field.placeholder"
            :value="field.default"
            :size="field.size"
        >
    </div>
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-math_captcha">
<div class="wpuf-fields">
    <div class="wpuf-math-captcha wpuf-bg-slate-100 wpuf-border wpuf-border-dashed wpuf-border-slate-300">
        <ul class="captcha wpuf-flex wpuf-items-center !wpuf-p-0 !wpuf-justify-around">
            <li class="refresh !wpuf-m-0 !wpuf-p-0">
                <svg fill="#555555" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" baseProfile="tiny" x="0px" y="0px" width="30px" height="30px" viewBox="0 0 480 480" xml:space="preserve" style="vertical-align: bottom;">
                    <g>
                        <path d="M383.434,172.242c-25.336-58.241-81.998-95.648-145.861-95.648c-65.309,0-125,40.928-148.514,101.827l49.5,19.117   c15.672-40.617,55.469-67.894,99.014-67.894c42.02,0,79.197,24.386,96.408,62.332l-36.117,14.428l92.352,53.279l27.01-100.933   L383.434,172.242z"></path>
                        <path d="M237.573,342.101c-41.639,0-79.615-25.115-96.592-62.819l35.604-13.763l-91.387-52.119l-27.975,98.249l34.08-13.172   c24.852,58.018,82.859,96.671,146.27,96.671c65.551,0,123.598-39.336,147.871-100.196l-49.268-19.652   C319.981,315.877,281.288,342.101,237.573,342.101z"></path>
                    </g>
                </svg>
            </li>
            <li class="captcha-number-area !wpuf-m-0 !wpuf-p-0">
                <p class="captcha-number">
                    <span v-html="captcha.operandOne"></span>
                    <span v-html="captcha.operator"></span>
                    <span v-html="captcha.operandTwo"></span>
                </p>
            </li>
            <li class="captcha-equal !wpuf-m-0 !wpuf-p-0">=</li>
            <li class="wpuf-max-w-full">
                <input
                    type="text"
                    :class="builder_class_names('textfield')"
                    :placeholder="field.placeholder"
                    :value="field.default"
                    :size="field.size"
                >
            </li>
        </ul>
    </div>

    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>

</script>

<script type="text/x-template" id="tmpl-wpuf-form-nickname">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-numeric_text_field">
<div class="wpuf-fields">
    <input
        type="number"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-password">
<div>

    <div class="wpuf-password-field">
        <div class="wpuf-label">
            <span v-if="field.show_icon === 'yes' && field.field_icon && field.icon_position === 'left_label'"
                  class="wpuf-field-label-icon wpuf-inline-flex wpuf-items-center wpuf-mr-1">
                  <i :class="[field.field_icon, 'wpuf-field-icon']"></i>
            </span>
            <label :for="'wpuf-' + field.name ? field.name : 'cls'">
                {{ field.label }} <span v-if="field.required && 'yes' === field.required" class="required">*</span>
            </label>
            <span v-if="field.show_icon === 'yes' && field.field_icon && field.icon_position === 'right_label'"
                  class="wpuf-field-label-icon wpuf-inline-flex wpuf-items-center wpuf-ml-2">
                  <i :class="[field.field_icon, 'wpuf-field-icon']"></i>
            </span>
        </div>

        <div class="wpuf-fields">
            <input
                type="text"
                :class="builder_class_names('textfield')"
                :placeholder="field.placeholder"
                :value="field.default"
                :size="field.size"
            >
            <span v-if="field.help" class="wpuf-help" v-html="field.help" />
        </div>
    </div>

    <div v-if="field.repeat_pass && 'yes' === field.repeat_pass" class="wpuf-password-field">
        <div class="wpuf-label">
            <span v-if="field.show_icon === 'yes' && field.field_icon && field.icon_position === 'left_label'"
                  class="wpuf-field-label-icon wpuf-inline-flex wpuf-items-center wpuf-mr-1">
                  <i :class="[field.field_icon, 'wpuf-field-icon']"></i>
            </span>
            <label :for="'wpuf-' + field.name ? field.name : 'cls'">
                {{ field.re_pass_label }} <span class="required">*</span>
            </label>
            <span v-if="field.show_icon === 'yes' && field.field_icon && field.icon_position === 'right_label'"
                  class="wpuf-field-label-icon wpuf-inline-flex wpuf-items-center wpuf-ml-2">
                  <i :class="[field.field_icon, 'wpuf-field-icon']"></i>
            </span>
        </div>

        <div class="wpuf-fields">
            <input
                type="text"
                :class="builder_class_names('textfield')"
                :size="field.size"
                :placeholder="field.re_pass_placeholder"
            >
            <span v-if="field.re_pass_help" class="wpuf-help wpuf-re-password-help" v-html="field.re_pass_help" />
        </div>
    </div>

    <div v-if="field.pass_strength && 'yes' === field.pass_strength" class="wpuf-password-field">
        <div class="wpuf-label">
        </div>
        <div class="wpuf-fields">
            <div class="password-strength-meter wpuf-w-fit wpuf-text-base wpuf-text-gray-700 wpuf-bg-emerald-200 wpuf-px-[16px] wpuf-py-[10px] wpuf-rounded-md">Strength indicator</div>
        </div>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-phone_field">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help"></span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-price_field">
<div class="wpuf-fields">
    <input
        type="number"
        step="0.01"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :readonly="field.price_input_mode === 'fixed'"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-pricing_checkbox">
<div class="wpuf-fields">
    <div
        v-if="field.inline !== 'yes'"
        class="wpuf-space-y-2">
        <div
            v-if="has_options" v-for="(option, key) in field.options" :key="key"
            class="wpuf-relative wpuf-flex wpuf-items-center">
            <div class="wpuf-flex wpuf-items-center">
                <input
                    type="checkbox"
                    :id="'pricing-checkbox-' + field.name + '-' + key"
                    :name="field.name + '[]'"
                    :value="key"
                    :checked="is_selected(key)"
                    :class="builder_class_names('checkbox')">
                <label :for="'pricing-checkbox-' + field.name + '-' + key">
                    {{ option }}
                    <span v-if="field.show_price_label === 'yes' && field.prices && field.prices[key]" class="wpuf-text-gray-600">
                        - {{ format_price(field.prices[key]) }}
                    </span>
                </label>
            </div>
        </div>
    </div>

    <div
        v-else
        class="wpuf-flex"
    >
        <div
            v-if="has_options" v-for="(option, key) in field.options" :key="key"
            class="wpuf-relative wpuf-flex wpuf-items-center wpuf-mr-4">
            <input
                type="checkbox"
                :id="'pricing-checkbox-' + field.name + '-' + key"
                :name="field.name + '[]'"
                :value="key"
                :checked="is_selected(key)"
                :class="builder_class_names('checkbox')"
                class="!wpuf-mt-[.5px] wpuf-rounded wpuf-border-gray-300 wpuf-text-indigo-600">
            <label :for="'pricing-checkbox-' + field.name + '-' + key">
                {{ option }}
                <span v-if="field.show_price_label === 'yes' && field.prices && field.prices[key]" class="wpuf-text-gray-600">
                    - {{ parseFloat(field.prices[key]).toFixed(2) }}
                </span>
            </label>
        </div>
    </div>

    <p v-if="field.help" class="wpuf-mt-2 wpuf-mb-0 wpuf-text-sm wpuf-text-gray-500" v-html="field.help"></p>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-pricing_dropdown">
<div class="wpuf-fields">
    <select :class="builder_class_names('select')">
        <option v-if="field.first" value="-1">{{ field.first }}</option>
        <option v-if="has_options" v-for="(option, key) in field.options" :key="key" :value="key" :selected="field.selected === key">
            {{ option }}<template v-if="field.prices && field.prices[key]"> - {{ format_price(field.prices[key]) }}</template>
        </option>
    </select>
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-pricing_multiselect">
<div class="wpuf-fields">
    <select :class="builder_class_names('select')" multiple style="height: 150px;">
        <option v-if="has_options" v-for="(option, key) in field.options" :key="key" :value="key" :selected="is_selected(key)">
            {{ option }}<template v-if="field.prices && field.prices[key]"> - {{ format_price(field.prices[key]) }}</template>
        </option>
    </select>
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-pricing_radio">
<div class="wpuf-fields">
    <div
        v-if="field.inline !== 'yes'"
        class="wpuf-space-y-2">
        <div
            v-if="has_options" v-for="(option, key) in field.options" :key="key"
            class="wpuf-flex wpuf-items-center">
            <input
                type="radio"
                :name="field.name"
                :value="key"
                :checked="field.selected === key"
                :id="'radio-' + field.name + '-' + key"
                :class="builder_class_names('radio')">
            <label :for="'radio-' + field.name + '-' + key">
                {{ option }}
                <span v-if="field.show_price_label === 'yes' && field.prices && field.prices[key]" class="wpuf-text-gray-600">
                    - {{ format_price(field.prices[key]) }}
                </span>
            </label>
        </div>
    </div>

    <div
        v-else
        class="wpuf-space-y-6 sm:wpuf-flex sm:wpuf-items-center sm:wpuf-space-x-10 sm:wpuf-space-y-0">
        <div
            v-if="has_options" v-for="(option, key) in field.options" :key="key"
            class="wpuf-flex wpuf-items-center">
            <input
                type="radio"
                :name="field.name"
                :value="key"
                :checked="field.selected === key"
                :id="'radio-' + field.name + '-' + key"
                :class="builder_class_names('radio')">
            <label :for="'radio-' + field.name + '-' + key">
                {{ option }}
                <span v-if="field.show_price_label === 'yes' && field.prices && field.prices[key]" class="wpuf-text-gray-600">
                    - {{ format_price(field.prices[key]) }}
                </span>
            </label>
        </div>
    </div>

    <p v-if="field.help" class="wpuf-mt-2 wpuf-mb-0 wpuf-text-sm wpuf-text-gray-500" v-html="field.help"></p>
</div></script>

<script type="text/x-template" id="tmpl-wpuf-form-profile_photo">
<div class="wpuf-fields">
    <div :id="'wpuf-img_label-' + field.id + '-upload-container'">
        <div class="wpuf-attachment-upload-filelist" data-type="file" data-required="yes">
            <a
                class="wpuf-inline-flex wpuf-items-center wpuf-gap-x-1.5"
                :class="builder_class_names('upload_btn')" href="#">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="wpuf-size-5">
                    <path d="M8.75 3.75a.75.75 0 0 0-1.5 0v3.5h-3.5a.75.75 0 0 0 0 1.5h3.5v3.5a.75.75 0 0 0 1.5 0v-3.5h3.5a.75.75 0 0 0 0-1.5h-3.5v-3.5Z" />
                </svg>
                <template v-if="field.button_label === ''">
                    <?php _e( 'Select Profile Photo', 'wpuf-pro' ); ?>
                </template>
                <template>
                    {{ field.button_label }}
                </template>
            </a>
        </div>
    </div>

    <span v-if="field.help" class="wpuf-help" v-html="field.help"></span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-ratings">
<div class="wpuf-fields">
    <div class="br-wrapper br-theme-css-stars">
        <div class="br-widget wpuf-flex wpuf-items-center">
            <a v-for="option in field.options" href="#"></a>
        </div>
    </div>

    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-really_simple_captcha">
<div class="wpuf-fields">
    <template v-if="!is_rs_captcha_active">
        <p v-html="no_plugin_msg"></p>
    </template>

    <template v-else>
        <div class="wpuf-flex">
            <div class="wpuf-w-1/4">
            <img class="wpuf-rs-captcha-placeholder" src="<?php echo WPUF_PRO_ASSET_URI . '/images/really-simple-captcha-placeholder.png' ?>" alt="">
            </div>
            <div class="wpuf-w-3/4">
            <input
                type="text"
                :class="builder_class_names('text')">
            </div>
        </div>
    </template>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-repeat_field">
<div class="wpuf-fields wpuf-repeat-field-builder-container">
    <label
        :for="field.name"
        class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium"
    >
        {{ field.label }} <help-text v-if="field.help_text" :text="field.help_text"></help-text>
    </label>
    <hr class="wpuf-mt-4">
    <!-- Sortable drop zone for inner fields -->
    <ul class="wpuf-repeat-fields-sortable-list wpuf-min-h-16">
        <!-- Empty state when no inner fields -->
        <div v-if="!field.inner_fields || field.inner_fields.length === 0"
             class="wpuf-flex wpuf-flex-col wpuf-items-center wpuf-justify-center wpuf-py-12 wpuf-px-4 wpuf-text-center">
            <svg class="wpuf-w-12 wpuf-h-12 wpuf-text-gray-300 wpuf-mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                <path vector-effect="non-scaling-stroke" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13h6m-3-3v6m-9 1V7a2 2 0 012-2h6l2 2h6a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2z" />
            </svg>
            <h3 class="wpuf-text-sm wpuf-font-medium wpuf-text-gray-900 wpuf-mb-2">
                <?php esc_html_e( 'No fields added yet', 'wp-user-frontend' ); ?>
            </h3>
            <p class="wpuf-text-xs wpuf-text-gray-500 wpuf-max-w-sm">
                <?php esc_html_e( 'Drag and drop fields from the sidebar to build your repeatable section.', 'wp-user-frontend' ); ?>
            </p>
        </div>

        <!-- Existing inner fields -->
        <li
            v-for="(innerField, idx) in field.inner_fields"
            :key="innerField.id"
            :repeat-field-index="idx"
            data-source="repeat-field-stage"
            class="!wpuf-m-0 !wpuf-p-0 wpuf-group/repeat-inner hover:wpuf-bg-green-50 wpuf-transition wpuf-duration-150 wpuf-ease-out repeat-field-items wpuf-el wpuf-rounded-t-md"
            :class="[
                innerField.name,
                innerField.css,
                'form-field-' + innerField.template,
                innerField.width ? 'field-size-' + innerField.width : '',
                ('custom_hidden_field' === innerField.template) ? 'hidden-field' : '',
                parseInt(editing_form_id) === parseInt(innerField.id) ? 'wpuf-bg-green-50' : ''
            ]">
            <div class="wpuf-flex wpuf-flex-col md:wpuf-flex-row wpuf-gap-2 wpuf-p-4 wpuf-border-transparent group-hover/repeat-inner:wpuf-border-green-400 wpuf-rounded-t-md wpuf-border-t wpuf-border-r wpuf-border-l wpuf-border-dashed wpuf-border-green-400">
                <div
                    v-if="!(is_full_width(innerField.template) || is_pro_preview(innerField.template))"
                    class="wpuf-w-1/4 wpuf-flex wpuf-items-center">
                    <span v-if="innerField.show_icon === 'yes' && innerField.field_icon && innerField.icon_position === 'left_label'"
                          class="wpuf-field-label-icon wpuf-inline-flex wpuf-items-center wpuf-mr-1">
                          <i :class="[innerField.field_icon, 'wpuf-field-icon']"></i>
                    </span>
                    <label
                           :for="'wpuf-' + (innerField.name ? innerField.name : 'cls')"
                           class="wpuf-block wpuf-text-sm">
                        {{ innerField.label }}
                        <span v-if="innerField.required && 'yes' === innerField.required"
                              class="required">*</span>
                    </label>
                    <span v-if="innerField.show_icon === 'yes' && innerField.field_icon && innerField.icon_position === 'right_label'"
                          class="wpuf-field-label-icon wpuf-inline-flex wpuf-items-center wpuf-ml-2">
                          <i :class="[innerField.field_icon, 'wpuf-field-icon']"></i>
                    </span>
                </div>
                <div
                    :class="[
                     'wpuf-relative wpuf-min-w-0',
                     (is_full_width(innerField.template) || is_pro_preview(innerField.template))
                       ? 'wpuf-w-full'
                       : 'wpuf-w-full md:wpuf-w-3/4'
                   ]">
                    <div class="wpuf-absolute wpuf-w-full wpuf-h-full "></div>
                    <div class="wpuf-relative">
                        <component
                            :is="'form-' + innerField.template"
                            :field="innerField">
                        </component>
                    </div>
                </div>
            </div>
            <div
                class="wpuf-repeat-field-control-buttons wpuf-opacity-0 group-hover/repeat-inner:wpuf-opacity-100 wpuf-rounded-b-lg wpuf-bg-green-600 wpuf-items-center wpuf-transition wpuf-duration-150 wpuf-ease-out wpuf-flex wpuf-justify-center">
                <div class="wpuf-items-center wpuf-text-green-200 wpuf-flex wpuf-justify-evenly">
                    <template v-if="!is_failed_to_validate(innerField.template)">
                        <span>
                            <i class="fa fa-arrows move wpuf-pr-2 wpuf-rounded-l-md hover:!wpuf-cursor-move wpuf-border-r wpuf-border-green-200 wpuf-text-[17px]"></i>
                        </span>
                        <span :class="action_button_classes"
                              class="!wpuf-px-2"
                            @click="open_inner_field_settings(innerField, idx)">
                            <svg class="wpuf-mr-2" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.43306 13.9163L6.69485 10.7618C6.89603 10.2589 7.19728 9.802 7.58033 9.41896L14.4995 2.50023C15.3279 1.6718 16.6711 1.6718 17.4995 2.50023C18.3279 3.32865 18.3279 4.6718 17.4995 5.50023L10.5803 12.419C10.1973 12.802 9.74042 13.1033 9.23746 13.3044L6.08299 14.5662C5.67484 14.7295 5.2698 14.3244 5.43306 13.9163Z" fill="#A7F3D0"/>
<path d="M3.5 5.74951C3.5 5.05916 4.05964 4.49951 4.75 4.49951H10C10.4142 4.49951 10.75 4.16373 10.75 3.74951C10.75 3.3353 10.4142 2.99951 10 2.99951H4.75C3.23122 2.99951 2 4.23073 2 5.74951V15.2495C2 16.7683 3.23122 17.9995 4.75 17.9995H14.25C15.7688 17.9995 17 16.7683 17 15.2495V9.99951C17 9.5853 16.6642 9.24951 16.25 9.24951C15.8358 9.24951 15.5 9.5853 15.5 9.99951V15.2495C15.5 15.9399 14.9404 16.4995 14.25 16.4995H4.75C4.05964 16.4995 3.5 15.9399 3.5 15.2495V5.74951Z" fill="#A7F3D0"/>
</svg>
                        </span>
                        <span :class="action_button_classes"
                              class="!wpuf-px-2"
                            @click="clone_inner_field(innerField, idx)">
                            <svg class="wpuf-mr-2" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.75 6.875V5C13.75 3.96447 12.9105 3.125 11.875 3.125H5C3.96447 3.125 3.125 3.96447 3.125 5V11.875C3.125 12.9105 3.96447 13.75 5 13.75H6.875M13.75 6.875H15C16.0355 6.875 16.875 7.71447 16.875 8.75V15C16.875 16.0355 16.0355 16.875 15 16.875H8.75C7.71447 16.875 6.875 16.0355 6.875 15V13.75M13.75 6.875H8.75C7.71447 6.875 6.875 7.71447 6.875 8.75V13.75" stroke="#A7F3D0" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
                        </span>
                    </template>
                    <template v-else>
                        <span :class="action_button_classes">
                            <i class="fa fa-arrows control-button-disabled wpuf--ml-1 wpuf-rounded-l-md"></i>
                        </span>
                        <span :class="action_button_classes">
                            <i class="fa fa-pencil control-button-disabled wpuf--ml-1"></i>
                        </span>
                        <span :class="action_button_classes">
                            <i class="fa fa-clone control-button-disabled wpuf--ml-1"></i>
                        </span>
                    </template>
                    <span :class="action_button_classes" @click="delete_inner_field(idx)">
                        <svg class="wpuf-mr-2" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.2837 7.5L11.9952 15M8.00481 15L7.71635 7.5M16.023 4.82547C16.308 4.86851 16.592 4.91456 16.875 4.96358M16.023 4.82547L15.1332 16.3938C15.058 17.3707 14.2434 18.125 13.2637 18.125H6.73631C5.75655 18.125 4.94198 17.3707 4.86683 16.3938L3.97696 4.82547M16.023 4.82547C15.0677 4.6812 14.1013 4.57071 13.125 4.49527M3.125 4.96358C3.40798 4.91456 3.69198 4.86851 3.97696 4.82547M3.97696 4.82547C4.93231 4.6812 5.89874 4.57071 6.875 4.49527M13.125 4.49527V3.73182C13.125 2.74902 12.3661 1.92853 11.3838 1.8971C10.9244 1.8824 10.463 1.875 10 1.875C9.53696 1.875 9.07565 1.8824 8.61618 1.8971C7.63388 1.92853 6.875 2.74902 6.875 3.73182V4.49527M13.125 4.49527C12.0938 4.41558 11.0516 4.375 10 4.375C8.94836 4.375 7.9062 4.41558 6.875 4.49527" stroke="#A7F3D0" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
                    </span>
                </div>
            </div>
        </li>
    </ul>

    <!-- Static + and - icons (no interactivity) -->
    <div class="wpuf-repeat-controls wpuf-p-4">
        <button type="button" class="wpuf-border wpuf-border-gray-100 wpuf-bg-white wpuf-px-[8px] wpuf-py-[2px] wpuf-rounded-[3px]">+</button>
        <button type="button" class="wpuf-border wpuf-border-gray-100 wpuf-bg-white wpuf-px-[8px] wpuf-py-[2px] wpuf-rounded-[3px]">-</button>
    </div>

    <span v-if="field.help" class="wpuf-help" v-html="field.help"></span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-shortcode">
<div class="wpuf-flex wpuf-items-center">
    <div class="wpuf-fields" v-html="field.shortcode"></div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-step_start">
<div>
    <div class="step-start-indicator">
        <div class="hr-line"></div>
        <span class="step-label">{{ field.label }}</span>
    </div>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-time_field">
<div class="wpuf-fields">
    <select
        :class="builder_class_names('dropdown')"
    >
        <option v-if="field.first_option" value="-1">{{ field.first_option }}</option>
    </select>

    <span v-if="field.help" class="wpuf-help" v-html="field.help"></span>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-toc">
<div class="wpuf-toc-container wpuf-fields wpuf-flex wpuf-items-center !wpuf-w-full">
    <input v-if="field.show_checkbox" type="checkbox" :class="builder_class_names('checkbox')" class="!wpuf-mr-2">
    <div class="wpuf-toc-description" v-html="content"></div>
</div>

</script>

<script type="text/x-template" id="tmpl-wpuf-form-twitter_url">
<div class="wpuf-fields">
    <!-- Icon next to label if enabled -->
    <div class="wpuf-social-input-wrapper" :class="field.width ? 'wpuf-' + field.width : 'wpuf-medium'">
        <input
            type="url"
            :class="builder_class_names('url')"
            :placeholder="field.placeholder"
            :value="field.default"
            :size="field.size"
        >
    </div>
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-user_bio">
<div class="wpuf-fields">
    <textarea
        v-if="'no' === field.rich"
        :class="builder_class_names('textareafield')"
        :placeholder="field.placeholder"
        :rows="field.rows"
        :cols="field.cols"
    >{{ field.default }}</textarea>

    <text-editor v-if="'no' !== field.rich" :rich="field.rich"></text-editor>

    <span v-if="field.help" class="wpuf-help" v-html="field.help"/>
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-user_email">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-user_login">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-form-user_url">
<div class="wpuf-fields">
    <input
        type="text"
        :class="builder_class_names('textfield')"
        :placeholder="field.placeholder"
        :value="field.default"
        :size="field.size"
    >
    <span v-if="field.help" class="wpuf-help" v-html="field.help" />
</div>
</script>

<script type="text/x-template" id="tmpl-wpuf-integration-conditional-logic">
    <div class="wpuf-integration-conditional-logic-container">
        <div class="wpuf-my-4 wpuf-input-container">
            <div class="wpuf-flex wpuf-items-center">
                <label class="wpuf-flex wpuf-text-sm wpuf-text-gray-700 wpuf-my-2">
                    {{ label }}
                    <help-text :text="'Choose whether to apply conditions for ' + integrationName + ' integration'"></help-text>
                </label>
            </div>
            <div>
                <label style="margin-right: 2rem;">
                    <input
                        type="radio"
                        :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][condition_status]'"
                        value="yes"
                        v-model="condition_status"
                        class="wpuf-integrations-conditional-logic !wpuf-mr-2 wpuf-radio !wpuf-shadow-none checked:!wpuf-shadow-none focus:checked:!wpuf-shadow-primary !wpuf-border-gray-300 checked:!wpuf-border-primary checked:!wpuf-bg-primary before:checked:!wpuf-bg-white hover:checked:!wpuf-bg-primary focus:!wpuf-ring-transparent focus:checked:!wpuf-ring-transparent hover:checked:!wpuf-ring-transparent focus:checked:!wpuf-bg-primary focus:checked:!wpuf-shadow-none focus:wpuf-shadow-primary">
                    <?php _e( 'Yes', 'wpuf-pro' ); ?>
                </label>
                <label>
                    <input
                        type="radio"
                        :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][condition_status]'"
                        value="no"
                        v-model="condition_status"
                        class="wpuf-integrations-conditional-logic !wpuf-mr-2 wpuf-radio !wpuf-shadow-none checked:!wpuf-shadow-none focus:checked:!wpuf-shadow-primary !wpuf-border-gray-300 checked:!wpuf-border-primary checked:!wpuf-bg-primary before:checked:!wpuf-bg-white hover:checked:!wpuf-bg-primary focus:!wpuf-ring-transparent focus:checked:!wpuf-ring-transparent hover:checked:!wpuf-ring-transparent focus:checked:!wpuf-bg-primary focus:checked:!wpuf-shadow-none focus:wpuf-shadow-primary">
                    <?php _e( 'No', 'wpuf-pro' ); ?>
                </label>
            </div>
        </div>

        <div v-if="condition_status === 'yes'" class="wpuf-conditional-logic-settings wpuf-my-4">
            <p class="wpuf-text-sm wpuf-leading-6 wpuf-mb-4">
                <span class="wpuf-mb-3 wpuf-block">
                    <?php
                    printf(
                        __( 'Apply %s integration when%s%s%sof these rules are met%s', 'wpuf-pro' ),
                        '{{ integrationName }}',
                        '</span>',
                        '<select v-model="cond_logic" class="wpuf-no-selectize wpuf-py-[10px] wpuf-px-[14px] wpuf-font-medium wpuf-w-1/3">
                            <option v-for="option in rule_options" :value="option.value" :key="option.value">{{ option.label }}</option>
                        </select>',
                        '<span class="wpuf-ml-3">',
                        '</span>'
                    );
                    ?>
            </p>

            <div class="wpuf-conditional-logic-rules">
                <div v-for="(condition, index) in conditions" :key="condition.id" class="wpuf-conditional-rule wpuf-grid wpuf-grid-cols-7 wpuf-gap-4 wpuf-mb-4">
                    <!-- Field Selection -->
                    <div class="cond-field wpuf-col-span-2">
                        <select
                            v-model="condition.name"
                            @change="on_change_cond_field(index)"
                            class="wpuf-no-selectize wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent">
                            <option value=""><?php esc_html_e( '- Select Field -', 'wpuf-pro' ); ?></option>
                            <option
                                v-for="field in conditional_fields"
                                :value="field.name"
                                :key="field.name">
                                {{ field.label }}
                            </option>
                        </select>
                    </div>

                    <!-- Operator Selection -->
                    <div class="cond-operator wpuf-col-span-2">
                        <select
                            v-model="condition.operator"
                            @change="on_change_cond_operator(index)"
                            class="wpuf-no-selectize wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent">
                            <option
                                v-for="operator in get_cond_operators(condition.name)"
                                :value="operator.value"
                                :key="operator.value">
                                {{ operator.label }}
                            </option>
                        </select>
                    </div>

                    <!-- Value Selection -->
                    <div class="cond-option wpuf-relative wpuf-col-span-2">
                        <!-- Text Input -->
                        <input
                            v-if="show_textfield(condition.name)"
                            v-model="condition.option"
                            @input="on_change_cond_option(index)"
                            type="text"
                            :disabled="is_disabled(condition.operator)"
                            class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent disabled:wpuf-bg-gray-100 disabled:wpuf-cursor-not-allowed">

                        <!-- Dropdown Selection -->
                        <select
                            v-if="show_dropdown(condition.name)"
                            v-model="condition.option"
                            @change="on_change_cond_option(index)"
                            :disabled="is_disabled(condition.operator)"
                            class="wpuf-no-selectize wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent disabled:wpuf-bg-gray-100 disabled:wpuf-cursor-not-allowed">
                            <option value=""><?php esc_html_e( '- Select Option -', 'wpuf-pro' ); ?></option>
                            <option
                                v-for="option in get_cond_options(condition.name)"
                                :value="option.value"
                                :key="option.value">
                                {{ option.label }}
                            </option>
                        </select>
                    </div>

                    <!-- Action Buttons -->
                    <div class="cond-action-btns wpuf-flex wpuf-my-2">
                        <span
                            v-if="conditions.length > 1"
                            @click="delete_condition(index)"
                            class="wpuf-repeater-remove hover:wpuf-cursor-pointer wpuf-mr-2">
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                fill="none"
                                viewBox="0 0 24 24"
                                stroke-width="1.5"
                                stroke="currentColor"
                                class="wpuf-size-6 wpuf-border wpuf-rounded-2xl wpuf-border-gray-400 hover:wpuf-border-primary wpuf-p-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h14" />
                            </svg>
                        </span>
                        <span
                            v-if="conditions.length === index + 1"
                            @click="add_condition"
                            class="wpuf-repeater-add hover:wpuf-cursor-pointer">
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                fill="none"
                                viewBox="0 0 24 24"
                                stroke-width="1.5"
                                stroke="currentColor"
                                class="wpuf-ml-1 wpuf-size-6 wpuf-border wpuf-rounded-2xl wpuf-border-gray-400 wpuf-p-1">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                                </svg>
                        </span>
                    </div>
                </div>
            </div>

            <div class="description wpuf-text-sm wpuf-text-gray-600 wpuf-mt-2">
                <?php printf( __( '%s integration will run if the above conditions are met.', 'wpuf-pro' ), '{{ integrationName | capitalize }}' ); ?>
            </div>
        </div>

        <!-- Hidden inputs for form submission -->
        <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][condition_status]'" :value="condition_status">
        <template v-if="condition_status === 'yes'">
            <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][cond_logic]'" :value="cond_logic">
            <template v-for="(condition, index) in conditions">
                <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][conditions][' + index + '][name]'" :value="condition.name">
                <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][conditions][' + index + '][operator]'" :value="condition.operator">
                <input type="hidden" :name="'wpuf_settings[' + settingsPath.replace(/\./g, '][') + '][conditions][' + index + '][option]'" :value="condition.option">
            </template>
        </template>
    </div>
</script>

<script type="text/x-template" id="tmpl-wpuf-submit-button-conditional-logic">
<div class="wpuf-submit-button-conditional-logic-container">
    <div class="wpuf-my-4 wpuf-input-container">
        <div class="wpuf-flex wpuf-items-center">
            <label class="wpuf-flex wpuf-text-sm wpuf-text-gray-700 wpuf-my-2">
                {{ label }}
                <help-text :text="'Choose whether to apply conditions for submit button visibility'"></help-text>
            </label>
        </div>
        <div>
            <label style="margin-right: 2rem;">
                <input
                    type="radio"
                    name="wpuf_settings[submit_button_cond][condition_status]"
                    value="yes"
                    v-model="condition_status"
                    class="wpuf-submit-conditional-logic !wpuf-mr-2 wpuf-radio !wpuf-shadow-none checked:!wpuf-shadow-none focus:checked:!wpuf-shadow-primary !wpuf-border-gray-300 checked:!wpuf-border-primary checked:!wpuf-bg-primary before:checked:!wpuf-bg-white hover:checked:!wpuf-bg-primary focus:!wpuf-ring-transparent focus:checked:!wpuf-ring-transparent hover:checked:!wpuf-ring-transparent focus:checked:!wpuf-bg-primary focus:checked:!wpuf-shadow-none focus:wpuf-shadow-primary">
                <?php _e( 'Yes', 'wpuf-pro' ); ?>
            </label>
            <label>
                <input
                    type="radio"
                    name="wpuf_settings[submit_button_cond][condition_status]"
                    value="no"
                    v-model="condition_status"
                    class="wpuf-submit-conditional-logic !wpuf-mr-2 wpuf-radio !wpuf-shadow-none checked:!wpuf-shadow-none focus:checked:!wpuf-shadow-primary !wpuf-border-gray-300 checked:!wpuf-border-primary checked:!wpuf-bg-primary before:checked:!wpuf-bg-white hover:checked:!wpuf-bg-primary focus:!wpuf-ring-transparent focus:checked:!wpuf-ring-transparent hover:checked:!wpuf-ring-transparent focus:checked:!wpuf-bg-primary focus:checked:!wpuf-shadow-none focus:wpuf-shadow-primary">
                <?php _e( 'No', 'wpuf-pro' ); ?>
            </label>
        </div>
    </div>

    <div v-if="condition_status === 'yes'" class="wpuf-conditional-logic-settings wpuf-my-4">
        <p class="wpuf-text-sm wpuf-leading-6 wpuf-mb-4">
            <span class="wpuf-mb-3 wpuf-block">
                <?php
                printf(
                    __( 'Show submit button when%s%s%sof these rules are met%s', 'wpuf-pro' ),
                    '</span>',
                    '<select v-model="cond_logic" name="wpuf_settings[submit_button_cond][cond_logic]" class="wpuf-py-[10px] wpuf-px-[14px] wpuf-font-medium wpuf-w-1/3 wpuf-no-selectize">
                        <option v-for="option in rule_options" :value="option.value" :key="option.value">{{ option.label }}</option>
                    </select>',
                    '<span class="wpuf-ml-3">',
                    '</span>'
                );
                ?>
        </p>

        <div class="wpuf-conditional-logic-rules">
            <div v-for="(condition, index) in conditions" :key="condition.id" class="wpuf-conditional-rule wpuf-grid wpuf-grid-cols-4 wpuf-gap-4 wpuf-mb-4">
                <!-- Field Selection -->
                <div class="cond-field">
                    <select
                        v-model="condition.name"
                        :name="`wpuf_settings[submit_button_cond][conditions][${index}][name]`"
                        class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent wpuf-no-selectize">
                        <option value=""><?php esc_html_e( '- Select Field -', 'wpuf-pro' ); ?></option>
                        <option
                            v-for="field in conditional_fields"
                            :value="field.name"
                            :key="field.name">
                            {{ field.label }}
                        </option>
                    </select>
                </div>

                <!-- Operator Selection -->
                <div class="cond-operator">
                    <select
                        v-model="condition.operator"
                        :name="`wpuf_settings[submit_button_cond][conditions][${index}][operator]`"
                        class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent wpuf-no-selectize">
                        <option
                            v-for="operator in get_cond_operators(condition.name)"
                            :value="operator.value"
                            :key="operator.value">
                            {{ operator.label }}
                        </option>
                    </select>
                </div>

                <!-- Value Selection -->
                <div class="cond-option wpuf-relative">
                    <!-- Text Input -->
                    <input
                        v-if="show_textfield(condition.name)"
                        v-model="condition.option"
                        :name="`wpuf_settings[submit_button_cond][conditions][${index}][option]`"
                        type="text"
                        :disabled="is_disabled(condition.operator)"
                        class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent disabled:wpuf-bg-gray-100 disabled:wpuf-cursor-not-allowed">

                    <!-- Dropdown Selection -->
                    <select
                        v-if="show_dropdown(condition.name)"
                        v-model="condition.option"
                        :name="`wpuf_settings[submit_button_cond][conditions][${index}][option]`"
                        :disabled="is_disabled(condition.operator)"
                        class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent disabled:wpuf-bg-gray-100 disabled:wpuf-cursor-not-allowed wpuf-no-selectize">
                        <option value=""><?php esc_html_e( '- Select Option -', 'wpuf-pro' ); ?></option>
                        <option
                            v-for="option in get_cond_options(condition.name)"
                            :value="option.value"
                            :key="option.value">
                            {{ option.label }}
                        </option>
                    </select>
                </div>

                <!-- Action Buttons -->
                <div>
                    <button
                        type="button"
                        @click="add_condition"
                        class="wpuf-p-1 wpuf-text-green-600 hover:wpuf-text-green-800 focus:wpuf-outline-none"
                        title="<?php esc_attr_e( 'Add Condition', 'wpuf-pro' ); ?>">
                        <svg class="wpuf-w-5 wpuf-h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-11a1 1 0 10-2 0v2H7a1 1 0 100 2h2v2a1 1 0 102 0v-2h2a1 1 0 100-2h-2V7z" clip-rule="evenodd"></path>
                        </svg>
                    </button>
                    <button
                        v-if="conditions.length > 1"
                        type="button"
                        @click="delete_condition(index)"
                        class="wpuf-p-1 wpuf-text-red-600 hover:wpuf-text-red-800 focus:wpuf-outline-none"
                        title="<?php esc_attr_e( 'Remove Condition', 'wpuf-pro' ); ?>">
                        <svg class="wpuf-w-5 wpuf-h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM7 9a1 1 0 000 2h6a1 1 0 100-2H7z" clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <div class="description wpuf-text-sm wpuf-text-gray-600 wpuf-mt-2">
            <?php _e( 'Submit button will be shown/hidden based on the above conditions.', 'wpuf-pro' ); ?>
        </div>
        
        <!-- Hidden inputs for form submission when conditions are enabled -->
        <input type="hidden" name="wpuf_settings[submit_button_cond][condition_status]" :value="condition_status">
        <input type="hidden" name="wpuf_settings[submit_button_cond][cond_logic]" :value="cond_logic">
        <template v-for="(condition, index) in conditions">
            <input type="hidden" :name="`wpuf_settings[submit_button_cond][conditions][${index}][name]`" :value="condition.name">
            <input type="hidden" :name="`wpuf_settings[submit_button_cond][conditions][${index}][operator]`" :value="condition.operator">
            <input type="hidden" :name="`wpuf_settings[submit_button_cond][conditions][${index}][option]`" :value="condition.option">
            <input type="hidden" :name="`wpuf_settings[submit_button_cond][conditions][${index}][input_type]`" :value="condition.input_type">
        </template>
    </div>

    <!-- Hidden inputs for form submission when conditions are disabled -->
    <div v-else>
        <input type="hidden" name="wpuf_settings[submit_button_cond][condition_status]" :value="condition_status">
        <input type="hidden" name="wpuf_settings[submit_button_cond][cond_logic]" value="any">
        <input type="hidden" name="wpuf_settings[submit_button_cond][conditions][0][name]" value="">
        <input type="hidden" name="wpuf_settings[submit_button_cond][conditions][0][operator]" value="=">
        <input type="hidden" name="wpuf_settings[submit_button_cond][conditions][0][option]" value="">
        <input type="hidden" name="wpuf_settings[submit_button_cond][conditions][0][input_type]" value="">
    </div>
</div>
</script>
