<?php

namespace WeDevs\Wpuf\Pro\Admin\Forms\PostTemplates;

use WeDevs\Wpuf\Admin\Forms\Form_Template;

/**
 * Professional Artwork submission form template
 */
class Post_Form_Template_Artwork extends Form_Template {

    public function __construct() {
        $this->enabled     = true;
        $this->title       = __( 'Professional Artwork Submission', 'wpuf-pro' );
        $this->description = __( 'Feature-rich form for artists to submit their work for galleries, exhibitions, or calls for art.', 'wpuf-pro' );
        $this->image       = WPUF_PRO_ASSET_URI . '/images/templates/artwork.svg';
        $this->form_fields = [
            // Section 1: Artist Information
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'yes',
                'label'           => 'Artist\'s Full Name',
                'name'            => 'artist_name',
                'is_meta'         => 'yes',
                'help'            => 'The legal or professional name of the artist for attribution.',
                'css'             => '',
                'placeholder'     => '',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'email_address',
                'template'        => 'email_address',
                'required'        => 'yes',
                'label'           => 'Contact Email',
                'name'            => 'contact_email',
                'is_meta'         => 'yes',
                'help'            => 'The best email for the gallery to send notifications and decisions.',
                'css'             => '',
                'placeholder'     => '',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'phone',
                'template'        => 'phone_field',
                'required'        => 'no',
                'label'           => 'Contact Phone',
                'name'            => 'contact_phone',
                'is_meta'         => 'yes',
                'help'            => 'Essential for quick communication regarding logistics or sales.',
                'css'             => '',
                'placeholder'     => '',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'website_url',
                'template'        => 'website_url',
                'required'        => 'no',
                'label'           => 'Portfolio Website',
                'name'            => 'portfolio_website',
                'is_meta'         => 'yes',
                'help'            => 'Allows curators to view a broader body of the artist\'s work.',
                'css'             => '',
                'placeholder'     => 'https://',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            // Section 2: Artwork Details
            [
                'input_type'      => 'text',
                'template'        => 'post_title',
                'required'        => 'yes',
                'label'           => 'Artwork Title',
                'name'            => 'post_title',
                'is_meta'         => 'no',
                'help'            => 'The official title of the piece. This becomes the post title.',
                'css'             => '',
                'placeholder'     => '',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'taxonomy',
                'template'        => 'taxonomy',
                'required'        => 'yes',
                'label'           => 'Artwork Category',
                'name'            => 'category',
                'is_meta'         => 'no',
                'help'            => 'Select a category for your artwork.',
                'first'           => __( '- Select -', 'wpuf-pro' ),
                'css'             => '',
                'type'            => 'select',
                'orderby'         => 'name',
                'order'           => 'ASC',
                'exclude_type'    => 'exclude',
                'exclude'         => [],
                'woo_attr'        => 'no',
                'woo_attr_vis'    => 'no',
                'options'         => [],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'image_upload',
                'template'        => 'featured_image',
                'count'           => '1',
                'required'        => 'yes',
                'label'           => 'Artwork Image',
                'name'            => 'featured_image',
                'button_label'    => 'Upload Artwork Image',
                'is_meta'         => 'no',
                'help'            => 'The primary, high-quality image of the artwork for review.',
                'css'             => '',
                'max_size'        => '5120',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'          => 'textarea',
                'template'            => 'post_content',
                'required'            => 'no',
                'label'               => 'Artist Statement',
                'name'                => 'post_content',
                'is_meta'             => 'no',
                'help'                => 'The description or story behind the piece. This is the main content.',
                'css'                 => '',
                'rows'                => '8',
                'cols'                => '25',
                'placeholder'         => '',
                'default'             => '',
                'rich'                => 'yes',
                'insert_image'        => 'yes',
                'word_restriction'    => '',
                'wpuf_cond'           => $this->conditionals,
                'wpuf_visibility'     => $this->get_default_visibility_prop(),
                'text_editor_control' => [],
                'show_in_post'        => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'yes',
                'label'           => 'Medium',
                'name'            => 'artwork_medium',
                'is_meta'         => 'yes',
                'help'            => '',
                'css'             => '',
                'placeholder'     => 'e.g., Oil on canvas, Digital print, Bronze sculpture',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'yes',
                'label'           => 'Dimensions',
                'name'            => 'artwork_dimensions',
                'is_meta'         => 'yes',
                'help'            => 'Critical for space planning.',
                'css'             => '',
                'placeholder'     => 'H x W x D in cm/in',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'numeric_text',
                'template'        => 'numeric_text_field',
                'required'        => 'no',
                'label'           => 'Year of Completion',
                'name'            => 'year_completed',
                'is_meta'         => 'yes',
                'help'            => 'The year the artwork was created. Helps establish a timeline.',
                'css'             => '',
                'placeholder'     => '',
                'default'         => '',
                'size'            => '40',
                'step_text_field' => '1',
                'min_value_field' => '1900',
                'max_value_field' => date('Y'),
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'text',
                'template'        => 'text_field',
                'required'        => 'no',
                'label'           => 'Edition',
                'name'            => 'artwork_edition',
                'is_meta'         => 'yes',
                'help'            => 'Essential for prints/sculptures.',
                'css'             => '',
                'placeholder'     => 'e.g., Unique, 1 of 25',
                'default'         => '',
                'size'            => '40',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'file_upload',
                'template'        => 'file_upload',
                'required'        => 'no',
                'label'           => 'Detail Shots',
                'name'            => 'detail_shots',
                'is_meta'         => 'yes',
                'help'            => 'Allow up to 3 additional images (texture, signature, angle).',
                'css'             => '',
                'max_size'        => '5120',
                'count'           => '3',
                'extension'       => [ 'images' ],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            // Section 3: Commercial Info & Submission Agreement
            [
                'input_type'      => 'select',
                'template'        => 'dropdown_field',
                'required'        => 'no',
                'label'           => 'Framing Status',
                'name'            => 'framing_status',
                'is_meta'         => 'yes',
                'help'            => '',
                'css'             => '',
                'first'           => '- Select -',
                'options'         => [
                    'framed' => 'Framed',
                    'unframed' => 'Unframed',
                    'na' => 'N/A (Sculpture, etc.)',
                ],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'select',
                'template'        => 'dropdown_field',
                'required'        => 'no',
                'label'           => 'Submission Category',
                'name'            => 'submission_category',
                'is_meta'         => 'yes',
                'help'            => 'If you have multiple open calls.',
                'css'             => '',
                'first'           => '- Select -',
                'options'         => [
                    'summer_exhibition' => 'Summer Exhibition',
                    'digital_art_prize' => 'Digital Art Prize',
                    'general_submission' => 'General Submission',
                ],
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'yes',
            ],
            [
                'input_type'      => 'toc',
                'template'        => 'toc',
                'required'        => 'yes',
                'label'           => 'Terms of Submission',
                'name'            => 'submission_terms',
                'is_meta'         => 'yes',
                'help'            => 'Legally required checkbox.',
                'css'             => '',
                'description'     => 'I certify this is my original work and agree to the gallery\'s commission and insurance policies. I understand that my submission may be selected for exhibition and that the gallery retains the right to use images of my work for promotional purposes.',
                'show_checkbox'   => 'yes',
                'wpuf_cond'       => $this->conditionals,
                'wpuf_visibility' => $this->get_default_visibility_prop(),
                'show_in_post'    => 'no',
            ],
        ];
        $this->form_settings = [
            'post_type'          => 'post',
            'expiration_settings' => [],
            'post_status'        => 'draft',
            'default_cat'        => '-1',
            'post_permission'    => 'guest_post',
            'guest_post'         => 'true',
            'guest_details'      => 'on',
            'name_label'         => 'Name',
            'email_label'        => 'E-Mail',
            'guest_email_verify' => 'on',
            'message_restrict'   => 'This page is restricted. Please Log in / Register to view this page.',
            'redirect_to'        => 'same',
            'comment_status'     => 'closed',
            'submit_text'        => 'Submit Artwork',
            'submit_button_cond' => [
                'condition_status' => 'no',
                'cond_logic'       => 'any',
                'conditions'       => [
                    [
                        'name'     => '',
                        'operator' => '=',
                        'option'   => '',
                    ],
                ],
            ],
            'draft_post'         => 'true',
            'edit_post_status'   => 'draft',
            'edit_redirect_to'   => 'same',
            'update_message'     => 'Your artwork has been updated!',
            'edit_url'           => '',
            'update_text'        => 'Update Artwork',
            'form_template'      => 'post_form_template_artwork',
            'notification'       => [
                'new'          => 'on',
                'new_to'       => get_option( 'admin_email' ),
                'new_subject'  => 'New artwork submission',
                'new_body'     => 'Hi,
A new artwork has been submitted to your site {sitename} ({siteurl}).

Here are the details:
Artwork Title: {post_title}
Artist Name: {artist_name}
Contact Email: {contact_email}
Contact Phone: {contact_phone}
Portfolio: {portfolio_website}
Medium: {artwork_medium}
Dimensions: {artwork_dimensions}
Year: {year_completed}
Edition: {artwork_edition}
Framing Status: {framing_status}
Submission Category: {submission_category}
Artist Statement: {post_content}
Author: {author}
Post URL: {permalink}
Edit URL: {editlink}',
                'edit'         => 'on',
                'edit_to'      => get_option( 'admin_email' ),
                'edit_subject' => 'Artwork submission has been updated',
                'edit_body'    => 'Hi,
The artwork "{post_title}" has been updated.

Here are the details:
Artwork Title: {post_title}
Artist Name: {artist_name}
Contact Email: {contact_email}
Medium: {artwork_medium}
Dimensions: {artwork_dimensions}
Year: {year_completed}
Author: {author}
Post URL: {permalink}
Edit URL: {editlink}'
            ],
        ];
    }
}