<?php

namespace WeDevs\Wpuf\Pro\Fields\Traits;

/**
 * Pricing Field Trait
 *
 * Common functionality for all pricing fields
 *
 * @since 4.2.2
 */
trait Pricing_Field_Trait {

    /**
     * Get common pricing field option settings
     *
     * @since 4.2.2
     *
     * @param bool $include_inline     Whether to include inline option (default: true).
     * @param bool $include_show_price Whether to include show_price option (default: true).
     * @param bool $is_multiple        Whether field allows multiple selections (default: false).
     *
     * @return array Pricing field options array.
     */
    protected function get_pricing_field_options( $include_inline = true, $include_show_price = true, $is_multiple = false ) {
        $options = [
            [
                'name'          => 'options',
                'title'         => __( 'Options', 'wpuf-pro' ),
                'type'          => 'option-data-price',
                'is_multiple'   => $is_multiple,
                'section'       => 'basic',
                'priority'      => 12,
                'help_text'     => __( 'Add options with prices', 'wpuf-pro' ),
            ],
        ];

        if ( $include_show_price ) {
            $options[] = [
                'name'          => 'show_price_label',
                'title'         => __( 'Show Price', 'wpuf-pro' ),
                'type'          => 'radio',
                'options'       => [
                    'yes'   => __( 'Yes', 'wpuf-pro' ),
                    'no'    => __( 'No', 'wpuf-pro' ),
                ],
                'default'       => 'yes',
                'inline'        => true,
                'section'       => 'advanced',
                'priority'      => 23,
                'help_text'     => __( 'Show price after option labels', 'wpuf-pro' ),
            ];
        }

        $options[] = [
            'name'          => 'enable_quantity',
            'title'         => __( 'Enable Quantity', 'wpuf-pro' ),
            'type'          => 'radio',
            'options'       => [
                'yes'   => __( 'Yes', 'wpuf-pro' ),
                'no'    => __( 'No', 'wpuf-pro' ),
            ],
            'default'       => 'no',
            'inline'        => true,
            'section'       => 'advanced',
            'priority'      => 24,
            'help_text'     => __( 'Allow quantity selection for each option', 'wpuf-pro' ),
        ];

        if ( $include_inline ) {
            $options[] = [
                'name'          => 'inline',
                'title'         => __( 'Show in inline list', 'wpuf-pro' ),
                'type'          => 'radio',
                'options'       => [
                    'yes'   => __( 'Yes', 'wpuf-pro' ),
                    'no'    => __( 'No', 'wpuf-pro' ),
                ],
                'default'       => 'no',
                'inline'        => true,
                'section'       => 'advanced',
                'priority'      => 25,
                'help_text'     => __( 'Show options in inline list', 'wpuf-pro' ),
            ];
        }

        return $options;
    }
}
