<?php
$page = ! empty( $page ) ? $page : __( 'This', 'wpuf-pro' );
?>
<div class="wpuf-flex wpuf-items-center wpuf-h-[calc(100vh-4rem)]">
    <div class="wpuf-mx-auto wpuf-w-11/12 wpuf-px-8 wpuf-py-20 wpuf-flex wpuf-items-center wpuf-justify-between wpuf-rounded-md wpuf-bg-white">
        <div class="wpuf-w-2/3">
            <h2 class="wpuf-text-3xl wpuf-font-semibold wpuf-tracking-tight wpuf-text-gray-900">
                <?php
                esc_html_e( 'WPUF Pro License Required', 'wpuf-pro' );
                ?>
            </h2>
            <p class="wpuf-mt-6 wpuf-max-w-xl wpuf-text-pretty wpuf-text-lg wpuf-text-gray-600">
                <?php
                printf(
                    /* translators: %s: page */
                    esc_html__( ' %s is a premium feature available only with an active WPUF Pro license. To unlock and use this feature, please activate your license key.', 'wpuf-pro' ),
                    $page
                );
                ?>
            </p>
        </div>
        <div class="wpuf-mt-10 wpuf-flex wpuf-items-center wpuf-gap-x-6 lg:shrink-0">
            <a href="<?php echo admin_url( 'admin.php?page=wpuf_updates' ); ?>" class="wpuf-btn-primary"><?php esc_html_e( 'Activate License', 'wpuf-pro' ); ?></a>
        </div>
    </div>
</div>
