<?php
/*
Plugin Name: Mailpoet 3
Plugin URI: https://wedevs.com/docs/wp-user-frontend-pro/modules/mailpoet3/
Thumbnail Name: mailpoet3.png
Description: Add subscribers to mailpoet mailing list when they registers via WP User Frontend Pro
Version: 1.0
Author: weDevs
Author URI: http://wedevs.com/
License: GPL2
*/


// don't call the file directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * WPUF_Mailpoet class
 *
 * @class WPUF_Mailpoet The class that holds the entire WPUF_Mailpoet plugin
 */
class WPUF_Mailpoet_3 {

    /**
     * Constructor for the WPUF_Mailpoet class
     *
     * Sets up all the appropriate hooks and actions
     * within our plugin.
     *
     * @uses add_action()
     */
    public function __construct() {
        add_action( 'wpuf_after_register', array( $this, 'subscribe_user_after_registration'), 10, 3 );

        // registration form setting items
        add_filter( 'wpuf_registration_form_module_settings_menu_sub_items', [ $this, 'add_settings_sub_menu' ] );
        add_filter( 'wpuf_registration_form_builder_setting_menu_contents', [ $this, 'add_settings_fields' ] );
    }

    /**
     * Add fields on registration form settings
     *
     * @since 4.1.0
     *
     * @param $fields
     *
     * @return array
     */
    public function add_settings_fields( $fields ) {
        if ( is_plugin_active( 'mailpoet/mailpoet.php' ) && class_exists( 'MailPoet\API\API' ) ) {
            $subscription_lists = \MailPoet\API\API::MP('v1')->getLists();

            $options = [];
            foreach ( $subscription_lists as $list ) {
                $options[$list['id']] = $list['name'];
            }

            $fields['modules']['mailpoet']['enable_mailpoet_3'] = [
                'label' => __( 'Enable Mailpoet 3', 'wpuf-pro' ),
                'type'  => 'toggle',
                'help_text' => __( 'Activate to connect your registration form with MailPoet, allowing for seamless email marketing processes', 'wpuf-pro' ),
            ];
            $fields['modules']['mailpoet']['mailpoet_3_list'] = [
                'label'   => __( 'Select Preferred List', 'wpuf-pro' ),
                'type'    => 'select',
                'options' => $options,
                'help_text'   => __( 'Select the MailPoet list where new sign-ups will be added as subscribers ', 'wpuf-pro' ),
            ];
        } else {
            $fields['modules']['mailpoet']['mailpoet_3_list'] = [
                'type'  => 'note',
                'note'  => __( 'You need to install and activate the <a href="https://wordpress.org/plugins/mailpoet/" target="_blank">MailPoet</a> plugin for this option to be available.', 'wpuf-pro' ),
            ];
        }

        return $fields;
    }

    /**
     * Add sub-menu settings heading on registration form
     *
     * @since 4.1.0
     *
     * @param $settings
     *
     * @return mixed
     */
    public function add_settings_sub_menu( $settings ) {
        $settings['mailpoet'] = [
            'label' => __( 'Mailpoet 3', 'wpuf-pro' ),
            'icon'  => '<svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.3919 3.58653L11.7137 10.9475C11.6041 11.2451 11.4632 11.433 11.2439 11.574C11.0246 11.6993 10.774 11.7463 10.4921 11.7463C10.0849 11.7463 9.78735 11.668 9.56809 11.5114C9.38015 11.3391 9.20787 11.1198 9.09824 10.8222L6.5767 4.15035V10.9632C6.5767 11.2138 6.49839 11.433 6.34178 11.621C6.1695 11.8089 5.87192 11.9029 5.44906 11.9029C5.04185 11.9029 4.74428 11.8246 4.572 11.668C4.39972 11.5114 4.33708 11.2608 4.33708 10.9162V1.17463C4.33708 0.767424 4.49369 0.469851 4.75994 0.281911C5.04185 0.109632 5.41774 0 5.91891 0C6.40442 0 6.79596 0.0783086 7.04655 0.281911C7.29714 0.485513 7.50074 0.7361 7.61037 1.08066L10.5078 9.35004L13.2642 1.15897C13.3895 0.751762 13.6088 0.469851 13.9064 0.281911C14.204 0.109632 14.6112 0.0313234 15.128 0.0313234C15.5978 0.0313234 15.9581 0.109632 16.24 0.281911C16.5219 0.45419 16.6472 0.7361 16.6472 1.08066V10.9475C16.6472 11.1981 16.5689 11.4174 16.4123 11.6053C16.24 11.7933 15.9424 11.8872 15.5195 11.8872C15.1123 11.8872 14.8304 11.8089 14.6581 11.6366C14.4859 11.4644 14.4076 11.2138 14.4076 10.8849C14.3919 10.8536 14.3919 3.58653 14.3919 3.58653ZM19.4819 14.2365C18.7145 13.8449 18.276 14.0642 18.0097 14.628C17.6652 15.2702 17.0231 15.6774 16.3026 15.6774H13.4522C12.3245 15.6774 11.2439 16.1472 10.4765 16.9146C9.70904 16.1472 8.62838 15.6774 7.50074 15.6774H4.6973C3.97686 15.6774 3.3034 15.2702 2.99017 14.628C2.70826 14.0642 2.28539 13.8606 1.51797 14.2365C0.860178 14.5654 0.703561 15.1135 0.985472 15.6774C1.69025 17.0556 3.11546 17.9327 4.66597 17.9327H7.5164C8.39346 17.9327 9.16088 18.5278 9.39581 19.3735C9.39581 19.3892 9.47412 20 10.4921 20C11.4945 20 11.5884 19.3735 11.5884 19.3735C11.8234 18.5435 12.5908 17.9327 13.4679 17.9327H16.3026C17.8688 17.917 19.294 17.0556 19.9988 15.6617C20.2964 15.1135 20.1554 14.5497 19.4819 14.2365Z" fill="#9CA3AF"/>
</svg>',
        ];

        return $settings;
    }

    /**
     * Initializes the WPUF_Mailpoet() class
     *
     * Checks for an existing WPUF_Mailpoet() instance
     * and if it doesn't find one, creates it.
     */
    public static function init() {
        static $instance = false;

        if ( ! $instance ) {
            $instance = new WPUF_Mailpoet_3();
        }

        return $instance;
    }


    /**
     * Add Mailpoet tab in Each form
     *
     * @return void
     */
    public function add_tab_profile_form() {
        ?>
            <a href="#wpuf-metabox-mailpoet-3" class="nav-tab" id="wpuf_mailpoet-3-tab"><?php _e( 'Mailpoet 3', 'wpuf-pro' ); ?></a>
        <?php
    }

    /**
     * Display settings option in tab content
     *
     * @return void
     */
    public function add_tab_content_profile_form() {
        ?>
        <div id="wpuf-metabox-mailpoet-3" class="group">
            <?php require_once dirname( __FILE__ ) . '/templates/mailpoet-3-settigs-tab.php'; ?>
        </div>
        <?php
    }

    /**
     * Send Subscribe request in Mailpoet
     *
     * @param  integer $user_id
     * @param  integer $form_id
     * @param  array $form_settings
     */
    public function subscribe_user_after_registration( $user_id, $form_id, $form_settings ) {
        if ( !is_plugin_active( 'mailpoet/mailpoet.php' ) ) {
            return;
        }

        if ( $form_settings['enable_mailpoet_3'] == 'no' ) {
            return;
        }

        $user = get_user_by( 'id', $user_id );

        $list_ids[] = $form_settings['mailpoet_3_list'];

        $subscriber_data = array(
            'email' => $user->user_email,
            'segments' => $list_ids,
            'first_name' => $user->first_name,
            'last_name' => $user->last_name,
            'status' => 'subscribed'
        );

        try {
            $subscriber = \MailPoet\API\API::MP('v1')->subscribeToList( $user->user_email, $form_settings['mailpoet_3_list'] );
        } catch ( Exception $exception ) {
            return $exception->getMessage();
        }
    }

}

$baseplugin = WPUF_Mailpoet_3::init();
