<?php

namespace WPUF\UserDirectory;

use WeDevs\WpUtils\ContainerTrait;
use WPUF\UserDirectory\Api\Meta_Fields;
use WPUF\UserDirectory\Api\User_Listing;
use WPUF\UserDirectory\Api\User_Profile;

class API {
    use ContainerTrait;

    /**
     * Class constructor.
     *
     * @since 4.2.0
     */
    public function __construct() {
        // Store objects in container using __set
        $this->container['user_listing'] = new User_Listing();
        $this->container['user_profile'] = new User_Profile();
        $this->container['meta_fields']  = new Meta_Fields();

        add_action( 'rest_api_init', [ $this, 'init_api' ] );
    }

    /**
     * API initialization
     *
     * @since 4.2.0
     *
     * @return void
     */
    public function init_api() {
        if ( ! isset( $this->container ) || ! is_array( $this->container ) ) {
            return;
        }

        foreach ( $this->container as $object ) {
            if ( is_object( $object ) && method_exists( $object, 'register_routes' ) ) {
                $object->register_routes();
            }
        }
    }
}
