// User Comments Block Registration
// Registers the WPUF User Comments inner block

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Comments', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="22" height="20" viewBox="0 0 22 20" fill="#fff" xmlns="http://www.w3.org/2000/svg">
        <path fill="#fff" d="M19.25 6.51567C20.1341 6.80012 20.75 7.64384 20.75 8.61286V12.8984C20.75 14.0351 19.9026 14.9989 18.7697 15.0913C18.4308 15.119 18.0909 15.1432 17.75 15.1639V18.2546L14.75 15.2546C13.3963 15.2546 12.0556 15.1994 10.7302 15.0913C10.4319 15.0669 10.1534 14.9821 9.90494 14.8497M19.25 6.51567C19.0986 6.46696 18.9393 6.43464 18.7739 6.42092C17.4472 6.3108 16.1051 6.25464 14.75 6.25464C13.3948 6.25464 12.0528 6.3108 10.7261 6.42091C9.59499 6.51479 8.75 7.47787 8.75 8.61285V12.8983C8.75 13.7357 9.20986 14.4792 9.90494 14.8497M19.25 6.51567V4.64195C19.25 3.02053 18.0983 1.61529 16.4903 1.40655C14.4478 1.1414 12.365 1.00464 10.2503 1.00464C8.13533 1.00464 6.05233 1.14142 4.00963 1.40663C2.40173 1.61538 1.25 3.02062 1.25 4.64202V10.8673C1.25 12.4887 2.40173 13.8939 4.00964 14.1027C4.58661 14.1776 5.16679 14.2422 5.75 14.2965V19.0046L9.90494 14.8497" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
