/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';

// Search Bar Preview Component
function SearchBarPreview({ enabled = true, placeholder }) {
	// Note: enabled prop is kept for backward compatibility but not used
	// The parent component now controls when this component is rendered

	return (
        <div
            className="wpuf-search-preview">
            <div className="wpuf-mt-2 wpuf-grid wpuf-grid-cols-1">
                <input
                    type="text"
                    disabled
                    className="wpuf-col-start-1 wpuf-row-start-1 wpuf-block wpuf-w-full wpuf-rounded-md wpuf-bg-white wpuf-py-1.5 wpuf-pl-3 wpuf-pr-10 wpuf-text-base wpuf-text-gray-900 wpuf-outline wpuf-outline-1 -wpuf-outline-offset-1 wpuf-outline-gray-300 placeholder:wpuf-text-gray-400 focus:wpuf-outline focus:wpuf-outline-2 focus:-wpuf-outline-offset-2 focus:owpuf-utline-indigo-600 sm:wpuf-pr-9 sm:text-sm/6"
                    placeholder={placeholder || __( 'Search Users', 'wpuf-pro' )}/>
                <svg
                    className="wpuf-pointer-events-none wpuf-col-start-1 wpuf-row-start-1 wpuf-mr-3 wpuf-size-5 wpuf-self-center wpuf-justify-self-end wpuf-text-gray-400 sm:wpuf-size-4"
                    width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M16.5 16.5L11.5 11.5M13.1667 7.33333C13.1667 10.555 10.555 13.1667 7.33333 13.1667C4.11167 13.1667 1.5 10.555 1.5 7.33333C1.5 4.11167 4.11167 1.5 7.33333 1.5C10.555 1.5 13.1667 4.11167 13.1667 7.33333Z"
                        stroke="#9CA3AF" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                </svg>
            </div>
        </div>
    );
}

export default SearchBarPreview; 