/**
 * WordPress dependencies
 */
import { useSelect } from '@wordpress/data';
import { store as blockEditorStore } from '@wordpress/block-editor';
import { InspectorControls } from '@wordpress/block-editor';

/**
 * Internal dependencies
 */
import UserDirectoryContent from './user-directory-content';
import UserDirectoryPlaceholder from './user-directory-placeholder';
import SimpleInspectorControls from './inspector-controls/simple-controls';

/**
 * Simplified edit component for MVP
 */
const SimpleUserDirectoryEdit = (props) => {
	const { clientId, attributes } = props;

	const hasInnerBlocks = useSelect(
		(select) => !!select(blockEditorStore).getBlocks(clientId).length,
		[clientId]
	);

	const Component = hasInnerBlocks ? UserDirectoryContent : UserDirectoryPlaceholder;

	return (
		<>
			<InspectorControls>
				<SimpleInspectorControls
					attributes={attributes}
					setQuery={props.setQuery}
					setAttributes={props.setAttributes}
				/>
			</InspectorControls>

			<Component {...props} />
		</>
	);
};

export default SimpleUserDirectoryEdit;
