/**
 * WordPress dependencies
 */
import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import metadata from './block.json';
import edit from './edit';
import save from './save';
import variations from './variations';

import './style.css';

const { name } = metadata;
export { metadata, name };

// For now, use the block.json attributes directly
// Schema-driven attributes will be added in a future update
export const settings = {
	...metadata,
	icon: 
	<svg width="18" height="18" viewBox="0 0 18 18" fill="#fff" xmlns="http://www.w3.org/2000/svg">
		<rect x="2.25" y="2.25" width="13.5" height="13.5" rx="1" fill="#fff" stroke="#059669" strokeWidth="1.5"/>
		<path d="M5.25 6H12.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
		<path d="M5.25 9H12.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
		<path d="M5.25 12H9.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
		<path d="M12.75 6L15.75 9L12.75 12" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
		<path d="M2.25 15.75H15.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
	</svg>,
	edit,
	example: {
		viewportWidth: 800,
		attributes: {
			roles: 'all',
			directory_layout: 'layout-2',
			max_item_per_page: 6,
			orderby: 'display_name',
			order: 'asc',
			enable_search: true,
			search_placeholder: 'Search Users'
		},
		innerBlocks: [
			{
				name: 'wpuf-ud/directory-item',
				attributes: {},
				innerBlocks: [
					{
						name: 'wpuf-ud/avatar',
						attributes: {
							avatarSize: 'medium',
							avatarShape: 'circle'
						}
					},
					{
						name: 'wpuf-ud/name',
						attributes: {
							nameFormat: 'display_name',
							headingLevel: 'h3'
						}
					},
					{
						name: 'wpuf-ud/bio',
						attributes: {
							characterLimit: 100,
							readMoreStyle: 'none'
						}
					}
				]
			}
		]
	},
	save,
	variations,
};
