/**
 * Internal dependencies
 */
// Import CSS for blocks
import '../../css/block-user-directory.css';

// Import block registry system
import { BlockRegistry } from './registry';

// Register all blocks using the registry system
BlockRegistry.registerAll(['directory', 'directory-item', 'profile', 'avatar', 'name', 'bio', 'contact', 'posts', 'comments', 'files', 'social', 'custom-field', 'tabs', 'profile-button', 'message-button', 'unmatched-blocks']);

// Add our custom block group icon
(function () {
    var el = wp.element.createElement;
    var SVG = wp.primitives.SVG;
    var rect1 = el('rect', { width: 37, height: 37, rx: 18.5, fill: '#6DBC34' });
    var rect2 = el('rect', { width: 37, height: 37, rx: 18.5, fill: '#23B89A' });
    var path1 = el('path', { d: 'M20.0146 19.6328V21.6357C20.0146 22.7883 19.0887 23.7142 17.9361 23.7142C16.7835 23.7142 15.8576 22.7883 15.8576 21.6357V19.6328H13.5713V21.6357C13.5713 24.0543 15.5364 26.0005 17.9361 26.0005C20.3547 26.0005 22.3009 24.0354 22.3009 21.6357V19.6328H20.0146Z', fill: 'white' });
    var path2 = el('path', { d: 'M15.8575 13H10L10.6991 15.2863H15.8575V13Z', fill: 'white' });
    var path3 = el('path', { d: 'M23.6992 13H20.0146V15.2863H23.6992C24.0204 15.2863 24.2661 15.5509 24.2661 15.8532C24.2661 16.1744 24.0016 16.42 23.6992 16.42H20.0146V18.7064H23.6992C25.2675 18.7064 26.5524 17.4215 26.5524 15.8532C26.5524 14.2849 25.2864 13 23.6992 13Z', fill: 'white' });
    var path4 = el('path', { d: 'M15.8573 16.4395H11.1523L11.8326 18.7258H15.8573V16.4395Z', fill: 'white' });

    var svgIcon = el(
        SVG,
        { width: 37, height: 37, viewBox: '0 0 37 37' },
        rect1, rect2, path1, path2, path3, path4
    );

    wp.blocks.updateCategory('wpuf-ud', { icon: svgIcon });
})();

// Export the registry for external use
export { BlockRegistry, BLOCK_REGISTRY } from './registry';
