// User Posts Block Registration
// Registers the WPUF User Posts inner block

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Posts', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="18" viewBox="0 0 18 18" fill="#fff" xmlns="http://www.w3.org/2000/svg">
        <rect x="2.25" y="2.25" width="13.5" height="13.5" rx="1" stroke="#059669" fill="#fff" strokeWidth="1.5"/>
        <path d="M5.25 6H12.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
        <path d="M5.25 9H12.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
        <path d="M5.25 12H9.75" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
        <path d="M12.75 6L15.75 9L12.75 12" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
