import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('WPUF - User Profile', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="18" viewBox="0 0 18 18" fill="#fff" xmlns="http://www.w3.org/2000/svg">
        <path d="M9 7.5C10.6569 7.5 12 6.15685 12 4.5C12 2.84315 10.6569 1.5 9 1.5C7.34315 1.5 6 2.84315 6 4.5C6 6.15685 7.34315 7.5 9 7.5Z" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
        <path d="M16.5 16.5C16.5 12.6421 13.3579 9.5 9.5 9.5H8.5C4.64213 9.5 1.5 12.6421 1.5 16.5" fill="#fff" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
