// User Tabs Block Registration
// Registers the WPUF User Tabs inner block

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Tabs', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="18" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg">
        <rect x="2" y="4" width="14" height="11" rx="1" fill="#059669"/>
        <rect x="2" y="2" width="4" height="3" rx="1" fill="#059669"/>
        <rect x="7" y="2" width="4" height="3" rx="1" fill="#059669"/>
        <rect x="12" y="2" width="4" height="3" rx="1" fill="#059669"/>
        <rect x="4" y="6" width="2" height="1" fill="#fff"/>
        <rect x="9" y="6" width="2" height="1" fill="#fff"/>
        <rect x="14" y="6" width="2" height="1" fill="#fff"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
