/**
 * Standard Block Template - index.js
 *
 * This file serves as a template for all WPUF User Directory blocks.
 * Copy this structure when creating new blocks or standardizing existing ones.
 *
 * @since 4.2.0
 */

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

// Import block components
import Edit from './edit';
import Save from './save';
import metadata from './block.json';

// Import block styles
import './style.css';

const { name } = metadata;

/**
 * Block Settings
 *
 * Standard configuration for WPUF blocks.
 * All blocks should follow this pattern for consistency.
 */
export const settings = {
    ...metadata,

    // Block title (translatable)
    title: __('Block Title', 'wpuf-pro'),

    // Block description (translatable)
    description: metadata.description || __('Block description', 'wpuf-pro'),

    // Block icon (SVG recommended)
    icon: (
        <svg width="18" height="18" viewBox="0 0 18 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
            {/* Replace with appropriate icon */}
            <rect width="18" height="18" rx="2" fill="currentColor"/>
        </svg>
    ),

    // Block category
    category: metadata.category || 'wpuf',

    // Block keywords for search
    keywords: [
        __('keyword1', 'wpuf-pro'),
        __('keyword2', 'wpuf-pro'),
        __('keyword3', 'wpuf-pro'),
    ],

    // Block supports
    supports: {
        html: false,
        align: false,
        anchor: true,
        color: {
            background: true,
            text: true,
        },
        spacing: {
            margin: true,
            padding: true,
        },
        typography: {
            fontSize: true,
            lineHeight: true,
        },
    },

    // Block attributes (defined in block.json)
    attributes: metadata.attributes,

    // Edit component
    edit: Edit,

    // Save component
    save: Save,

    // Block example (for block inserter)
    example: {
        attributes: {
            // Define example attributes for block preview
        },
    },

    // Block transforms (if needed)
    transforms: {
        // Define block transforms here
    },

    // Block deprecations (if needed)
    deprecated: [
        // Define deprecated versions here
    ],
};

// Export for registry system
export { metadata, name };
