/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { PanelBody, PanelRow } from '@wordpress/components';

/**
 * Standard Inspector Controls Component
 * 
 * Provides a consistent structure for inspector controls across all blocks
 * with organized sections: Display, Content, Advanced
 */
export default function StandardInspectorControls({ 
    children, 
    displayPanel = true, 
    contentPanel = true, 
    advancedPanel = true,
    displayPanelTitle = __('Display Options', 'wpuf-pro'),
    contentPanelTitle = __('Content Options', 'wpuf-pro'),
    advancedPanelTitle = __('Advanced Options', 'wpuf-pro'),
    displayPanelInitialOpen = true,
    contentPanelInitialOpen = false,
    advancedPanelInitialOpen = false
}) {
    return (
        <InspectorControls>
            {displayPanel && (
                <PanelBody 
                    title={displayPanelTitle} 
                    initialOpen={displayPanelInitialOpen}
                >
                    {children.display}
                </PanelBody>
            )}
            
            {contentPanel && (
                <PanelBody 
                    title={contentPanelTitle} 
                    initialOpen={contentPanelInitialOpen}
                >
                    {children.content}
                </PanelBody>
            )}
            
            {advancedPanel && (
                <PanelBody 
                    title={advancedPanelTitle} 
                    initialOpen={advancedPanelInitialOpen}
                >
                    {children.advanced}
                </PanelBody>
            )}
        </InspectorControls>
    );
}

/**
 * Standard Panel Row Component
 * Wraps controls in a consistent PanelRow for better organization
 */
export function StandardPanelRow({ children, className = '' }) {
    return (
        <PanelRow className={`wpuf-ud-panel-row ${className}`}>
            {children}
        </PanelRow>
    );
}

/**
 * Helper function to create organized inspector controls
 */
export function createInspectorControls(controls) {
    return {
        display: controls.display || null,
        content: controls.content || null,
        advanced: controls.advanced || null
    };
}
