import React from 'react';
import { __ } from '@wordpress/i18n';
import { getOptimalAvatarSize } from '../../utils/avatarSizeHelper';

const DirectoryLayout = ({ formData, setFormData }) => {

    const handleChange = (e) => {
        const { name, value } = e.target;
        
        // Auto-select avatar size when directory layout changes
        if (name === 'directory_layout') {
            const optimalSize = getOptimalAvatarSize(value);
            setFormData(prev => ({
                ...prev,
                [name]: value,
                avatar_size: optimalSize
            }));
        } else {
            setFormData(prev => ({ ...prev, [name]: value }));
        }
    };

    const layoutOptions = wpuf_ud.directory_layouts || {};
    
    // Custom display names for layouts
    const layoutDisplayNames = {
        'layout-1': 'Classic Table',
        'layout-2': 'Rounded Sidecard (2x)',
        'layout-3': 'Round Grid (3x)',
        'layout-4': 'Square Grid (3x)',
        'layout-5': 'Round Grid (4x)',
        'layout-6': 'Square Grid (4x)'
    };

    return (
        <div className="wpuf-flex wpuf-flex-col wpuf-justify-center wpuf-items-center wpuf-min-h-[350px]">
            <div className="wpuf-w-full wpuf-bg-white wpuf-max-w-3xl wpuf-mx-auto">
                <h2 className="wpuf-text-center"
                    style={{
                        
                        fontWeight: 400,
                        fontSize: '20px',
                        lineHeight: '36px',
                        letterSpacing: '0%',
                        textAlign: 'center',
                        color: '#000000'
                    }}
                >
                    {__('Directory Layout', 'wpuf-pro')}
                </h2>
                <p className="wpuf-text-center wpuf-mt-2"
                    style={{
                        
                        fontWeight: 400,
                        fontSize: '14px',
                        lineHeight: '20px',
                        letterSpacing: '0%',
                        textAlign: 'center',
                        color: '#64748B'
                    }}
                >{__('Choose how your user directory will be displayed. Pick a style that feels natural for your site—list, grid or wide layouts that match your site\'s style and user experience', 'wpuf-pro')}</p>
                <div className="wpuf-grid wpuf-grid-cols-3 wpuf-gap-2 wpuf-mt-12">
                    {Object.entries(layoutOptions).map(([value, option]) => (
                        <label
                            key={value}
                            className={`wpuf-relative wpuf-rounded-[10px] wpuf-cursor-pointer wpuf-flex wpuf-flex-col wpuf-items-center wpuf-transition-all wpuf-duration-200 wpuf-group wpuf-overflow-hidden wpuf-border ${formData.directory_layout === value ? 'wpuf-border-emerald-600' : 'wpuf-border-gray-300'}`}
                        >
                            <input
                                type="radio"
                                name="directory_layout"
                                value={value}
                                checked={formData.directory_layout === value}
                                onChange={handleChange}
                                className="wpuf-sr-only"
                            />
                            <div className="wpuf-relative">
                                <img
                                    src={option.image}
                                    alt={option.name}
                                    className="wpuf-w-full wpuf-h-auto wpuf-object-contain wpuf-max-w-full"
                                    style={{ imageRendering: 'crisp-edges', WebkitFontSmoothing: 'antialiased' }}
                                />
                                {/* Hover overlay with layout name */}
                                <div 
                                    className="wpuf-absolute wpuf-inset-0 wpuf-flex wpuf-items-center wpuf-justify-center wpuf-opacity-0 group-hover:wpuf-opacity-100 wpuf-transition-opacity wpuf-duration-300"
                                    style={{
                                        backgroundColor: 'rgba(236, 253, 245, 0.95)',
                                        borderRadius: '10px'
                                    }}
                                >
                                    <span 
                                        style={{
                                            
                                            fontSize: '16px',
                                            fontWeight: 600,
                                            color: '#059669'
                                        }}
                                    >{layoutDisplayNames[value] || option.name}</span>
                                </div>
                            </div>
                            {formData.directory_layout === value && (
                                <span 
                                    className="wpuf-absolute wpuf-flex wpuf-items-center wpuf-justify-center wpuf-z-10"
                                    style={{
                                        width: '20px',
                                        height: '20px',
                                        borderRadius: '23px',
                                        backgroundColor: '#059669',
                                        top: '12px',
                                        right: '12px',
                                        opacity: 1
                                    }}
                                >
                                    <svg width="8" height="6" viewBox="0 0 8 6" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.49927 2.5L3.49927 4.5L6.99927 1" stroke="white" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                                    </svg>
                                </span>
                            )}
                        </label>
                    ))}
                </div>
            </div>
        </div>
    );
};

export default DirectoryLayout;
