<?php
/**
 * Block Styling Helper Functions
 *
 * Provides styling utilities for block templates including inline styles,
 * CSS classes, and block editor styling integration.
 *
 * @since 4.2.0
 */







/**
 * Get responsive classes
 *
 * @param array $attributes Block attributes
 * @return array Responsive classes
 * @since 4.2.0
 */
function wpuf_get_responsive_classes($attributes) {
    $classes = [];

    // Add responsive visibility classes
    if (!empty($attributes['hideDesktop'])) {
        $classes[] = 'wpuf-hide-desktop';
    }

    if (!empty($attributes['hideTablet'])) {
        $classes[] = 'wpuf-hide-tablet';
    }

    if (!empty($attributes['hideMobile'])) {
        $classes[] = 'wpuf-hide-mobile';
    }

    return $classes;
}

/**
 * Get animation classes
 *
 * @param array $attributes Block attributes
 * @return array Animation classes
 * @since 4.2.0
 */
function wpuf_get_animation_classes($attributes) {
    $classes = [];

    if (!empty($attributes['animation'])) {
        $animation = $attributes['animation'];

        if (!empty($animation['type'])) {
            $classes[] = 'wpuf-animation-' . $animation['type'];
        }

        if (!empty($animation['duration'])) {
            $classes[] = 'wpuf-animation-duration-' . $animation['duration'];
        }

        if (!empty($animation['delay'])) {
            $classes[] = 'wpuf-animation-delay-' . $animation['delay'];
        }
    }

    return $classes;
}
