<?php
/**
 * Generalized Pagination template for user directory listings
 *
 * Expects:
 * @param array $pagination [ 'total_pages', 'current_page', 'per_page', 'total_items' ]
 * @param string $base_url (optional) Base URL for pagination links
 * @param array $query_args (optional) Query args to preserve (except 'page')
 * @since 4.2.0
 */

if ( empty( $pagination ) || $pagination['total_pages'] <= 1 ) {
    return;
}

$current = (int) $pagination['current_page'];
$total   = (int) $pagination['total_pages'];

// Determine base_url and query_args
// If base_url and query_args are not provided (e.g., from AJAX), use current URL
if ( ! isset( $base_url ) || ! isset( $query_args ) ) {
    $current_url = ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    $parsed_url = wp_parse_url( $current_url );
    $base_url = isset( $parsed_url['path'] ) ? $parsed_url['path'] : '';

    $query_args = [];
    if ( ! empty( $parsed_url['query'] ) ) {
        parse_str( $parsed_url['query'], $query_args );
    }
    unset( $query_args['page'] ); // We'll set this per link
}

// Determine URL builder function
$url_builder = $GLOBALS['wpuf_pagination_url_builder'] ?? 'wpuf_ud_build_page_url';

// Calculate page range (show 3, with ellipsis if needed)
$pages = [];
if ( $total <= 3 ) {
    for ( $i = 1; $i <= $total; $i++ ) {
        $pages[] = $i;
    }
} else {
    if ( $current <= 2 ) {
        $pages = [1, 2, 3];
    } elseif ( $current >= $total - 1 ) {
        $pages = [ $total - 2, $total - 1, $total ];
    } else {
        $pages = [ $current - 1, $current, $current + 1 ];
    }
}
?>
<div class="wpuf-flex wpuf-items-center wpuf-justify-center wpuf-mt-8">
    <nav class="wpuf-flex wpuf-items-center wpuf-w-full" aria-label="<?php esc_attr_e( 'Pagination', 'wpuf-pro' ); ?>">
        <a
            href="<?php echo $current > 1 ? call_user_func( $url_builder, $base_url, $query_args, 1 ) : '#'; ?>"
            class="wpuf-pagination-link wpuf-mr-2 wpuf-rounded-md wpuf-inline-flex wpuf-items-center wpuf-text-sm wpuf-font-medium wpuf-text-gray-700 hover:wpuf-text-primary<?php echo $current === 1 ? ' wpuf-cursor-not-allowed wpuf-opacity-50' : ''; ?>"
            aria-disabled="<?php echo $current === 1 ? 'true' : 'false'; ?>"
            tabindex="<?php echo $current === 1 ? '-1' : '0'; ?>"
        >
            <?php esc_html_e( 'First', 'wpuf-pro' ); ?>
        </a>
        <a
            href="<?php echo $current > 1 ? call_user_func( $url_builder, $base_url, $query_args, $current - 1 ) : '#'; ?>"
            class="wpuf-pagination-link wpuf-mr-2 wpuf-rounded-md wpuf-inline-flex wpuf-items-center wpuf-text-sm wpuf-font-medium wpuf-text-gray-700 hover:wpuf-text-primary<?php echo $current === 1 ? ' wpuf-cursor-not-allowed wpuf-opacity-50' : ''; ?>"
            aria-disabled="<?php echo $current === 1 ? 'true' : 'false'; ?>"
            tabindex="<?php echo $current === 1 ? '-1' : '0'; ?>"
        >
            <?php esc_html_e( 'Previous', 'wpuf-pro' ); ?>
        </a>
        <div class="wpuf-flex wpuf-items-center">
            <?php if ( $pages[0] > 1 ) : ?>
                <span class="wpuf-inline-flex wpuf-items-center wpuf-px-2 wpuf-text-gray-400">&hellip;</span>
            <?php endif; ?>
            <?php foreach ( $pages as $i ) : ?>
                <a
                    href="<?php echo $i === $current ? '#' : call_user_func( $url_builder, $base_url, $query_args, $i ); ?>"
                    class="wpuf-pagination-link wpuf-inline-flex wpuf-items-center wpuf-px-4 wpuf-py-2 wpuf-text-sm wpuf-font-medium wpuf-cursor-pointer wpuf-mx-1 wpuf-border-t-2<?php echo $i === $current ? ' wpuf-text-primary wpuf-border-primary' : ' wpuf-text-gray-500 wpuf-border-transparent'; ?> hover:wpuf-border-primary wpuf-transition-all"
                    aria-current="<?php echo $i === $current ? 'page' : 'false'; ?>"
                    tabindex="<?php echo $i === $current ? '-1' : '0'; ?>"
                >
                    <?php echo esc_html( $i ); ?>
                </a>
            <?php endforeach; ?>
            <?php if ( end( $pages ) < $total ) : ?>
                <span class="wpuf-inline-flex wpuf-items-center wpuf-px-2 wpuf-text-gray-400">&hellip;</span>
            <?php endif; ?>
        </div>
        <a
            href="<?php echo $current < $total ? call_user_func( $url_builder, $base_url, $query_args, $current + 1 ) : '#'; ?>"
            class="wpuf-pagination-link wpuf-ml-2 wpuf-rounded-md wpuf-inline-flex wpuf-items-center wpuf-text-sm wpuf-font-medium wpuf-text-gray-700 hover:wpuf-text-primary<?php echo $current === $total ? ' wpuf-cursor-not-allowed wpuf-opacity-50' : ''; ?>"
            aria-disabled="<?php echo $current === $total ? 'true' : 'false'; ?>"
            tabindex="<?php echo $current === $total ? '-1' : '0'; ?>"
        >
            <?php esc_html_e( 'Next', 'wpuf-pro' ); ?>
        </a>
        <a
            href="<?php echo $current < $total ? call_user_func( $url_builder, $base_url, $query_args, $total ) : '#'; ?>"
            class="wpuf-pagination-link wpuf-ml-2 wpuf-rounded-md wpuf-inline-flex wpuf-items-center wpuf-text-sm wpuf-font-medium wpuf-text-gray-700 hover:wpuf-text-primary<?php echo $current === $total ? ' wpuf-cursor-not-allowed wpuf-opacity-50' : ''; ?>"
            aria-disabled="<?php echo $current === $total ? 'true' : 'false'; ?>"
            tabindex="<?php echo $current === $total ? '-1' : '0'; ?>"
        >
            <?php esc_html_e( 'Last', 'wpuf-pro' ); ?>
        </a>
    </nav>
</div>
