<?php
$tab_title = ! empty( $tab_title ) ? $tab_title : __( 'Comments', 'wpuf-pro' );

// Get all user comments
$comments = get_comments([
    'user_id' => $user->ID,
    'status'  => 'approve',
    'orderby' => 'comment_date',
    'order'   => 'DESC'
]);
?>
<div class="wpuf-profile-section wpuf-ud-post-list">
    <h3 class="profile-section-heading"><?php echo esc_html( $tab_title ); ?></h3>

    <?php if ( ! empty( $comments ) ) : ?>
        <table class="user-post-list-table">
            <thead>
                <tr>
                    <th><?php esc_attr_e( 'Comment', 'wpuf-pro' ); ?></th>
                    <th><?php esc_attr_e( 'Commented On', 'wpuf-pro' ); ?></th>
                    <th><?php esc_attr_e( 'Comment Date', 'wpuf-pro' ); ?></th>
                    <th><?php esc_attr_e( 'Details', 'wpuf-pro' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ( $comments as $comment ) : ?>
                <tr>
                    <td class="avatar-column">
                        <div class="post-description">
                            <p><?php echo wp_trim_words( $comment->comment_content, 10 ); ?></p>
                        </div>
                    </td>
                    <td>
                        <?php echo get_the_title( $comment->comment_post_ID ); ?>
                    </td>
                    <td>
                        <?php echo esc_attr( mysql2date( get_option( 'date_format' ), $comment->comment_date ) ); ?>
                    </td>
                    <td>
                        <a href="<?php echo get_comment_link( $comment ); ?>"><?php esc_html_e( 'Read More', 'wpuf-pro' ); ?></a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
    <?php else : ?>
        <p><?php esc_html_e( 'No comments found', 'wpuf-pro' ); ?></p>
    <?php endif; ?>
</div>