<?php
/**
 * User Profile Layout 2 - Centered Card Design
 *
 * @since 4.2.0
 *
 * Available variables:
 * @var array $template_data Complete data including user info and settings
 * @var array $user User data array
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Extract data
$user = $template_data['user'];
$show_avatar = ! empty( $template_data['show_avatar'] );
$enable_tabs = ! empty( $template_data['enable_tabs'] );
$default_tabs = ! empty( $template_data['default_tabs'] ) ? $template_data['default_tabs'] : [ 'about' ];
$default_active_tab = ! empty( $template_data['default_active_tab'] ) ? $template_data['default_active_tab'] : 'about';
$avatar_size = ! empty( $template_data['avatar_size'] ) ? $template_data['avatar_size'] : 'thumbnail';

// Get avatar URL
$avatar_sizes = [
    'thumbnail' => 150,
    'medium' => 300,
    'large' => 600
];
$size = $avatar_sizes[ $avatar_size ] ?? 150;
$avatar_url = $user['avatar_urls'][ $size ] ?? $user['avatar_urls']['96'] ?? '';

?>

<div class="wpuf-profile-layout-2">
    <!-- Profile Card -->
    <div class="wpuf-profile-card">
        <!-- Avatar Section -->
        <?php if ( $show_avatar && $avatar_url ) : ?>
            <div class="wpuf-profile-avatar-wrapper">
                <div class="wpuf-profile-avatar">
                    <img src="<?php echo esc_url( $avatar_url ); ?>"
                         alt="<?php echo esc_attr( $user['name'] ?: $user['username'] ?: __( 'User Avatar', 'wpuf-pro' ) ); ?>"
                         class="wpuf-avatar-image" />
                </div>
            </div>
        <?php endif; ?>

        <!-- Profile Info -->
        <div class="wpuf-profile-info">
            <h2 class="wpuf-profile-name">
                <?php echo esc_html( $user['name'] ?: $user['username'] ?: __( 'Unknown User', 'wpuf-pro' ) ); ?>
            </h2>

            <?php if ( $user['email'] ) : ?>
                <div class="wpuf-profile-email">
                    <span class="wpuf-icon">📧</span>
                    <?php echo esc_html( $user['email'] ); ?>
                </div>
            <?php endif; ?>

            <?php if ( $user['url'] ) : ?>
                <div class="wpuf-profile-website">
                    <span class="wpuf-icon">🌐</span>
                    <a href="<?php echo esc_url( $user['url'] ); ?>" target="_blank" rel="noopener noreferrer">
                        <?php echo esc_html( $user['url'] ); ?>
                    </a>
                </div>
            <?php endif; ?>

            <?php if ( ! empty( $user['roles'] ) ) : ?>
                <div class="wpuf-profile-roles">
                    <span class="wpuf-icon">👤</span>
                    <?php echo esc_html( implode( ', ', $user['roles'] ) ); ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Bio Section -->
        <?php if ( ! empty( $template_data['show_bio'] ) && $user['description'] ) : ?>
            <div class="wpuf-profile-bio">
                <h4><?php esc_html_e( 'About', 'wpuf-pro' ); ?></h4>
                <div class="wpuf-bio-text">
                    <p><?php echo esc_html( $user['description'] ); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <!-- Profile Fields -->
        <?php if ( ! empty( $template_data['profile_fields'] ) ) : ?>
            <div class="wpuf-profile-fields">
                <h4><?php esc_html_e( 'Profile Information', 'wpuf-pro' ); ?></h4>
                <div class="wpuf-fields-grid">
                    <?php foreach ( $template_data['profile_fields'] as $field ) : ?>
                        <?php
                        $value = '';
                        $label = '';
                        switch ( $field ) {
                            case 'username':
                                $value = $user['username'];
                                $label = __( 'Username', 'wpuf-pro' );
                                break;
                            case 'display_name':
                                $value = $user['name'];
                                $label = __( 'Display Name', 'wpuf-pro' );
                                break;
                            case 'first_name':
                                $value = $user['first_name'];
                                $label = __( 'First Name', 'wpuf-pro' );
                                break;
                            case 'last_name':
                                $value = $user['last_name'];
                                $label = __( 'Last Name', 'wpuf-pro' );
                                break;
                            case 'email':
                                $value = $user['email'];
                                $label = __( 'Email', 'wpuf-pro' );
                                break;
                            case 'website':
                                $value = $user['url'];
                                $label = __( 'Website', 'wpuf-pro' );
                                break;
                        }
                        if ( $value ) :
                        ?>
                            <div class="wpuf-field-item">
                                <span class="wpuf-field-label"><?php echo esc_html( $label ); ?></span>
                                <span class="wpuf-field-value"><?php echo esc_html( $value ); ?></span>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Custom Fields -->
        <?php if ( ! empty( $template_data['custom_fields'] ) ) : ?>
            <div class="wpuf-custom-fields">
                <h4><?php esc_html_e( 'Additional Information', 'wpuf-pro' ); ?></h4>
                <div class="wpuf-fields-grid">
                    <?php foreach ( $template_data['custom_fields'] as $field ) : ?>
                        <?php if ( ! empty( $user['meta'][ $field ] ) ) : ?>
                            <div class="wpuf-field-item">
                                <span class="wpuf-field-label"><?php echo esc_html( ucwords( str_replace( '_', ' ', $field ) ) ); ?></span>
                                <span class="wpuf-field-value"><?php echo esc_html( $user['meta'][ $field ] ); ?></span>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Tabs Section -->
    <?php if ( $enable_tabs && ! empty( $default_tabs ) ) : ?>
        <div class="wpuf-profile-tabs">
            <!-- Tab Navigation -->
            <div class="wpuf-tab-nav">
                <?php foreach ( $default_tabs as $tab ) : ?>
                    <?php if ( in_array( $tab, [ 'about', 'posts', 'comments' ] ) ) : ?>
                        <button class="wpuf-tab-button <?php echo $tab === $default_active_tab ? 'active' : ''; ?>"
                                data-tab="<?php echo esc_attr( $tab ); ?>">
                            <?php
                            switch ( $tab ) {
                                case 'about':
                                    esc_html_e( 'About', 'wpuf-pro' );
                                    break;
                                case 'posts':
                                    esc_html_e( 'Posts', 'wpuf-pro' );
                                    break;
                                case 'comments':
                                    esc_html_e( 'Comments', 'wpuf-pro' );
                                    break;
                            }
                            ?>
                        </button>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>

            <!-- Tab Content -->
            <div class="wpuf-tab-content">
                <!-- About Tab -->
                <div class="wpuf-tab-content-about" style="<?php echo $default_active_tab !== 'about' ? 'display: none;' : ''; ?>">
                    <div class="wpuf-tab-content-inner">
                        <?php if ( ! empty( $template_data['show_bio'] ) && $user['description'] ) : ?>
                            <div class="wpuf-biography">
                                <h4><?php esc_html_e( 'Biography', 'wpuf-pro' ); ?></h4>
                                <div class="wpuf-bio-text">
                                    <p><?php echo esc_html( $user['description'] ); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Posts Tab -->
                <?php if ( in_array( 'posts', $default_tabs ) ) : ?>
                    <div class="wpuf-tab-content-posts"
                         data-load-content="posts"
                         style="<?php echo $default_active_tab !== 'posts' ? 'display: none;' : ''; ?>">
                        <div class="wpuf-loading">
                            <span class="dashicons dashicons-update"></span>
                            <?php esc_html_e( 'Loading posts...', 'wpuf-pro' ); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Comments Tab -->
                <?php if ( in_array( 'comments', $default_tabs ) ) : ?>
                    <div class="wpuf-tab-content-comments"
                         data-load-content="comments"
                         style="<?php echo $default_active_tab !== 'comments' ? 'display: none;' : ''; ?>">
                        <div class="wpuf-loading">
                            <span class="dashicons dashicons-update"></span>
                            <?php esc_html_e( 'Loading comments...', 'wpuf-pro' ); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div>
