<?php
/**
 * Plugin Name: Zapier
 * Description: Subscribe a contact to Zapier when a form is submited
 * Plugin URI: https://wedevs.com/docs/wp-user-frontend-pro/modules/zapier/
 * Thumbnail Name: zapier.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */

/**
 * Zapier CLass
 */
class WPUF_Zapier {

    function __construct() {
        add_action( 'wpuf_after_register', array( $this, 'subscribe_user' ), 10, 3 );

        // registration form setting items
        add_filter( 'wpuf_registration_form_module_settings_menu_sub_items', [ $this, 'add_settings_sub_menu' ] );
        add_filter( 'wpuf_registration_form_builder_setting_menu_contents', [ $this, 'add_settings_fields' ] );
    }

    /**
     * Add fields on registration form settings
     *
     * @since 4.1.0
     *
     * @param $fields
     *
     * @return array
     */
    public function add_settings_fields( $fields ) {
        $fields['modules']['zapier']['enable_zapier'] = [
            'label' => __( 'Enable Zapier', 'wpuf-pro' ),
            'type'  => 'toggle',
            'help_text' => __( 'Activate to connect your registration form with Zapier, facilitating seamless integration across multiple apps and services', 'wpuf-pro' ),
        ];
        $fields['modules']['zapier']['zapier_webhook'] = [
            'label'       => __( 'Zapier Webhook URL', 'wpuf-pro' ),
            'type'        => 'text',
            'placeholder' => 'https://hooks.zapier.com/hooks/catch/...',
            'help'        => sprintf(
                __( 'Please provide your %sZapier Webhook URL%s here', 'wpuf-pro' ),
                '<a href="https://zapier.com/app/dashboard" target="_blank" >', '</a>'
            ),
        ];

        return $fields;
    }

    /**
     * Add sub-menu settings heading on registration form
     *
     * @since 4.1.0
     *
     * @param $settings
     *
     * @return mixed
     */
    public function add_settings_sub_menu( $settings ) {
        $settings['zapier'] = [
            'label' => __( 'Zapier', 'wpuf-pro' ),
            'icon'  => '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect width="18" height="18" fill="#9CA3AF"/>
</svg>',
        ];

        return $settings;
    }

    /**
     * Require the Zapier class if not exists
     *
     * @return void
     */
    public function require_zapier() {
        if ( ! class_exists( 'Zapier' ) ) {
            require_once dirname( __FILE__ ) . '/class-zapier.php';
        }
    }

    /**
     * Add Zapier tab in Each form
     */
    public function add_tab_zapier_form() {
        ?>
        <a href="#wpuf-metabox-zapier" class="nav-tab" id="wpuf_zapier-tab"><?php _e( 'Zapier', 'wpuf-pro' ); ?></a>
        <?php
    }

    /**
     * Display settings option in tab content
     */
    public function add_tab_content_profile_form() {
        ?>
        <div id="wpuf-metabox-zapier" class="group">
            <?php require_once dirname( __FILE__ ) . '/templates/zapier-settings-tab.php'; ?>
        </div>
        <?php
    }

    /**
     * Subscribe a user when a form is submitted
     *
     * @param  int $user_id
     * @param  int $form_id
     * @param  array $form_settings
     *
     * @return void
     */
    public function subscribe_user( $user_id, $form_id, $form_settings ) {

        if ( ! isset( $form_settings['enable_zapier'] ) || $form_settings['enable_zapier'] == 'no' ) {
            return;
        }

        if ( isset( $_POST['action'] ) && $_POST['action'] != 'wpuf_submit_register' ) {
            return;
        }

        $postdata = $_POST;

        if ( empty( $postdata ) ) {
            return;
        }

        unset( $postdata['_wpnonce'] );
        unset( $postdata['_wp_http_referer'] );
        unset( $postdata['form_id'] );
        unset( $postdata['page_id'] );
        unset( $postdata['action'] );

        $webhook_url = $form_settings['zapier_webhook'];

        $this->require_zapier();

        $zapier = new Zapier( $webhook_url );

        $response = $zapier->call( json_encode( $postdata ) );

        return $response;
    }
}

new WPUF_Zapier();
