/**
 * Settings component for pricing option fields
 * Extends field-option-data with price support
 */
Vue.component('field-option-data-price', {
    template: '#tmpl-wpuf-field-option-data-price',

    mixins: [
        wpuf_mixins.option_field_mixin,
        wpuf_mixins.form_field_mixin
    ],

    data: function () {
        return {
            show_value: false,
            sync_value: true,
            options: [],
            selected: [],
            display: true
        };
    },

    computed: {
        field_options: function () {
            return this.editing_form_field.options;
        },

        field_prices: function () {
            return this.editing_form_field.prices || {};
        },

        field_selected: function () {
            return this.editing_form_field.selected;
        },

        is_multiple: function () {
            return this.option_field.is_multiple;
        }
    },

    mounted: function () {
        var self = this;

        this.set_options();

        $(this.$el).find('.option-field-option-chooser').sortable({
            items: '.option-field-option',
            handle: '.sort-handler',
            update: function (e, ui) {
                var item        = ui.item[0],
                    data        = item.dataset,
                    toIndex     = parseInt($(ui.item).index()),
                    fromIndex   = parseInt(data.index);

                self.options.swap(fromIndex, toIndex);
            }
        });
    },

    methods: {
        set_options: function () {
            var self = this;
            var field_options = $.extend(true, {}, this.editing_form_field.options);
            var field_prices = $.extend(true, {}, this.editing_form_field.prices || {});

            _.each(field_options, function (label, value) {
                self.options.push({
                    label: label,
                    value: value,
                    price: field_prices[value] || '0',
                    id: self.get_random_id()
                });
            });

            if (this.option_field.is_multiple && !_.isArray(this.field_selected)) {
                this.selected = [this.field_selected];
            } else {
                this.selected = this.field_selected;
            }
        },

        clear_selection: function () {
            if (this.option_field.is_multiple) {
                this.selected = [];
            } else {
                this.selected = null;
            }
        },

        add_option: function () {
            var count   = this.options.length,
                new_opt = this.i18n.option + '-' + (count + 1);

            this.options.push({
                label: new_opt,
                value: new_opt,
                price: '0',
                id: this.get_random_id()
            });
        },

        delete_option: function (index) {
            if (this.options.length === 1) {
                this.warn({
                    text: this.i18n.last_choice_warn_msg,
                    showCancelButton: false,
                    confirmButtonColor: "#46b450",
                });

                return;
            }

            this.options.splice(index, 1);
        },

        set_option_label: function (index, label) {
            if (this.sync_value) {
                this.options[index].value = label.toLocaleLowerCase().replace( /\s/g, '_' );
            }
        }
    },

    watch: {
        options: {
            deep: true,
            handler: function (new_opts) {
                var options = {},
                    prices = {},
                    i = 0;

                for (i = 0; i < new_opts.length; i++) {
                    options['' + new_opts[i].value] = new_opts[i].label;
                    prices['' + new_opts[i].value] = new_opts[i].price || '0';
                }

                this.update_value('options', options);
                this.update_value('prices', prices);
            }
        },

        selected: function (new_val) {
            this.update_value('selected', new_val);
        }
    }
});