<?php

namespace WeDevs\Wpuf\Pro\AI_Review\Interfaces;

/**
 * AI Provider Interface
 *
 * Defines the contract for AI providers
 *
 * @since 4.2.5
 */
interface Provider_Interface {

    /**
     * Make API call to the AI provider
     *
     * @since 4.2.5
     * @param string $endpoint API endpoint
     * @param string $api_key API key
     * @param string $model Model to use
     * @param string $prompt Review prompt
     * @return string API response
     * @throws \Exception
     */
    public function make_api_call( $endpoint, $api_key, $model, $prompt );

    /**
     * Validate API key format
     *
     * @since 4.2.5
     * @param string $api_key API key to validate
     * @return bool True if valid format
     */
    public function validate_api_key( $api_key );

    /**
     * Get supported models for this provider
     *
     * @since 4.2.5
     * @return array List of supported models
     */
    public function get_supported_models();
}
