<?php

namespace WeDevs\Wpuf\Pro\AI_Review;

use WeDevs\Wpuf\Pro\AI_Review\Scheduler;
use WeDevs\Wpuf\Pro\AI_Review\Post_Review;
use WeDevs\Wpuf\Pro\AI_Review\Post_Table;

/**
 * AI Review Manager - Admin interface for managing AI reviews
 *
 * @since 4.2.5
 */
class Manager {

    /**
     * Form Settings instance
     *
     * @var Form_Settings
     */
    private $form_settings;

    /**
     * Scheduler instance
     *
     * @var Scheduler
     */
    private $scheduler;

    /**
     * Post Review instance
     *
     * @var Post_Review
     */
    private $post_review;

    /**
     * Post Table instance
     *
     * @var Post_Table
     */
    private $post_table;

    /**
     * Constructor
     *
     * @since 4.2.5
     * @param Form_Settings|null $form_settings Optional form settings instance
     * @param Scheduler|null $scheduler Optional scheduler instance
     * @param Post_Review|null $post_review Optional post review instance
     * @param Post_Table|null $post_table Optional post table instance
     */
    public function __construct(
        Form_Settings $form_settings = null,
        Scheduler $scheduler = null,
        Post_Review $post_review = null,
        Post_Table $post_table = null
    ) {
        $this->form_settings = $form_settings ?: new Form_Settings();
        $this->scheduler = $scheduler ?: new Scheduler();
        $this->post_review = $post_review ?: new Post_Review();
        $this->post_table = $post_table ?: new Post_Table();
    }

    /**
     * Get form settings instance
     *
     * @since 4.2.5
     * @return Form_Settings
     */
    public function get_form_settings() {
        return $this->form_settings;
    }

    /**
     * Get scheduler instance
     *
     * @since 4.2.5
     * @return Scheduler
     */
    public function get_scheduler() {
        return $this->scheduler;
    }

    /**
     * Get post review instance
     *
     * @since 4.2.5
     * @return Post_Review
     */
    public function get_post_review() {
        return $this->post_review;
    }

    /**
     * Get post table instance
     *
     * @since 4.2.5
     * @return Post_Table
     */
    public function get_post_table() {
        return $this->post_table;
    }
}
