<?php

namespace WeDevs\Wpuf\Pro\Admin;

use WeDevs\Wpuf\Pro\Admin\Forms\Profile_Form_Template;

class Menu extends \WeDevs\Wpuf\Admin\Menu {
    public function __construct() {
        add_action( 'wpuf_admin_menu_top', [ $this, 'admin_menu_top' ] );
        add_action( 'wpuf_admin_menu_bottom', [ $this, 'admin_menu_bottom' ] );
        add_action( 'wpuf_admin_menu', [ $this, 'add_coupon_menu' ] );
    }

    /**
     * Callback method for WP User Frontend submenu
     *
     * @since 2.5
     *
     * @return void
     */
    public function add_coupon_menu() {
        if ( 'on' !== wpuf_get_option( 'enable_payment', 'wpuf_payment', 'on' ) ) {
            return;
        }

        $updater    = wpuf_pro()->admin->update;
        $capability = wpuf_admin_role();

        if ( ! $updater->get_license()->is_valid() ) {

            $page = add_submenu_page(
                $this->parent_slug,
                __( 'Coupons', 'wpuf-pro' ),
                __( 'Coupons', 'wpuf-pro' ),
                $capability,
                'wpuf-coupon',
                [ $this, 'wpuf_coupon_preview_page' ]
            );

            add_action( 'load-' . $page, [ $this, 'remove_admin_notice' ] );

            return;
        }

        add_submenu_page( wpuf()->admin->menu->parent_slug, __( 'Coupons', 'wpuf-pro' ), __( 'Coupons', 'wpuf-pro' ), $capability, 'edit.php?post_type=wpuf_coupon' );
    }

    /**
     * Callback method for modules preview page
     *
     * @since 4.1.3
     *
     * @return void
     */
    public function modules_preview_page() {
        wp_enqueue_style( 'wpuf-admin-pro', WPUF_PRO_ASSET_URI . '/css/admin-pro.css', [], WPUF_PRO_VERSION );

        $page = __( 'Modules', 'wpuf-pro' );

        include WPUF_PRO_INCLUDES . '/templates/need-to-update.php';
    }
    /**
     * Callback method for COUPON preview page
     *
     * @since 4.1.3
     *
     * @return void
     */
    public function wpuf_coupon_preview_page() {
        wp_enqueue_style( 'wpuf-admin-pro', WPUF_PRO_ASSET_URI . '/css/admin-pro.css', [], WPUF_PRO_VERSION );

        $page = __( 'Coupons', 'wpuf-pro' );

        include WPUF_PRO_INCLUDES . '/templates/need-to-update.php';
    }

    /**
     * Callback method for REGISTRATION preview page
     *
     * @since 4.1.3
     *
     * @return void
     */
    public function wpuf_registration_preview_page() {
        wp_enqueue_style( 'wpuf-admin-pro', WPUF_PRO_ASSET_URI . '/css/admin-pro.css', [], WPUF_PRO_VERSION );

        $page = __( 'Registration', 'wpuf-pro' );

        include WPUF_PRO_INCLUDES . '/templates/need-to-update.php';
    }

    /**
     * Callback method for WP User Frontend submenu
     *
     * @since 2.6
     *
     * @return void
     */
    public function admin_menu_bottom() {
        $updater    = wpuf_pro()->admin->update;
        $capability = wpuf_admin_role();

        if ( ! $updater->get_license()->is_valid() ) {
            $page = add_submenu_page( $this->parent_slug, __( 'Modules', 'wpuf-pro' ), __( 'Modules', 'wpuf-pro' ), $capability, 'wpuf-modules', [ $this, 'modules_preview_page' ] );
            add_action( 'load-' . $page, [ $this, 'remove_admin_notice' ] );

            return;
        }

        $modules = add_submenu_page( $this->parent_slug, __( 'Modules', 'wpuf-pro' ), __( 'Modules', 'wpuf-pro' ), $capability, 'wpuf-modules', [ $this, 'modules_page' ] );
        add_action( 'load-' . $modules, [ $this, 'modules_scripts' ] );
    }

    /**
     * Modules Page
     *
     * @since 2.7
     *
     * @return void
     **/
    public function modules_page() {
        include WPUF_PRO_INCLUDES . '/Admin/views/modules.php';
    }

    /**
     * Modules Scripts
     *
     * @since 2.7
     *
     * @return void
     **/
    public function modules_scripts() {
        wp_enqueue_style( 'wpuf-pro-module' );
        wp_enqueue_script( 'wpuf-jquery-blockui' );
        wp_enqueue_script( 'wpuf-pro-module' );

        $wpuf_module = apply_filters(
            'wpuf_module_localize_param', [
                'ajaxurl'      => admin_url( 'admin-ajax.php' ),
                'nonce'        => wp_create_nonce( 'wpuf-admin-nonce' ),
                'activating'   => __( 'Activating', 'wpuf-pro' ),
                'deactivating' => __( 'Deactivating', 'wpuf-pro' ),
            ]
        );

        wp_localize_script( 'wpuf-pro-module', 'wpuf_module', $wpuf_module );
    }

    /**
     * Callback method for WP User Frontend submenu
     *
     * @since 2.5
     *
     * @return void
     */
    public function admin_menu_top() {
        $updater    = wpuf_pro()->admin->update;
        $capability = wpuf_admin_role();

        if ( ! $updater->get_license()->is_valid() ) {
            $page = add_submenu_page(
                $this->parent_slug,
                __( 'Registration Forms', 'wpuf-pro' ),
                __( 'Registration Forms', 'wpuf-pro' ),
                $capability, 'wpuf-profile-forms', [ $this, 'wpuf_registration_preview_page' ]
            );

            add_action( 'load-' . $page, [ $this, 'remove_admin_notice' ] );

            return;
        }

        $profile_forms_page = add_submenu_page(
            $this->parent_slug,
            __( 'Registration Forms', 'wpuf-pro' ),
            __( 'Registration Forms', 'wpuf-pro' ),
            $capability, 'wpuf-profile-forms', [ $this, 'wpuf_profile_forms_page' ]
        );
        $this->all_submenu_hooks['profile_forms'] = $profile_forms_page;

        add_action( 'load-' . $profile_forms_page, [ $this, 'profile_form_menu_action' ] );
    }

    /**
     * Remove admin notice
     *
     * @since 4.1.3
     *
     * @return void
     */
    public function remove_admin_notice() {
        wpuf_remove_admin_notices();
    }

    /**
     * Callback method for Profile Forms submenu
     *
     * @since 2.5
     *
     * @return void
     */
    public function wpuf_profile_forms_page() {
        if ( defined( 'WPUF_VERSION' ) && version_compare( WPUF_VERSION, '4.1.4', '<' ) ) {
            require_once WPUF_PRO_INCLUDES . '/Admin/views/need-to-update.php';

            return;
        }

        // phpcs:ignore WordPress.Security.NonceVerification
        $action           = ! empty( $_GET['action'] ) ? sanitize_text_field( wp_unslash( $_GET['action'] ) ) : '';
        $add_new_page_url = admin_url( 'admin.php?page=wpuf-profile-forms&action=add-new' );
        $form_type        = __( 'Registration Form', 'wp-user-frontend' );

        switch ( $action ) {
            case 'edit':
            case 'add-new':
                require_once WPUF_PRO_INCLUDES . '/Admin/views/profile-form.php';
                break;

            default:
                wp_enqueue_style( 'wpuf-forms-list' );
                wp_enqueue_style( 'wpuf-pro-forms-list' );
                wp_enqueue_script( 'wpuf-pro-forms-list' );

                // Check AI configuration status
                $ai_settings = get_option( 'wpuf_ai', [] );
                $ai_provider = isset( $ai_settings['ai_provider'] ) ? $ai_settings['ai_provider'] : '';
                $ai_model    = isset( $ai_settings['ai_model'] ) ? $ai_settings['ai_model'] : '';
                $provider_key_field = $ai_provider . '_api_key';
                $ai_api_key = isset( $ai_settings[$provider_key_field] ) ? $ai_settings[$provider_key_field] : '';
                $ai_configured = !empty( $ai_provider ) && !empty( $ai_api_key ) && !empty( $ai_model );

                // Check if free AI Form Handler class is available (without triggering autoload)
                $ai_form_builder_available = class_exists( 'WeDevs\Wpuf\Admin\Forms\AI_Form_Handler', false );

                wp_localize_script('wpuf-pro-forms-list', 'wpuf_forms_list',
                    [
                        'post_type'                  => 'wpuf_profile',
                        'post_counts'                => wpuf_get_forms_counts_with_status( 'wpuf_profile' ),
                        'rest_nonce'                 => wp_create_nonce( 'wp_rest' ),
                        'rest_url'                   => esc_url_raw( get_rest_url() ),
                        'site_url'                   => esc_url_raw( get_site_url() ),
                        'admin_url'                  => esc_url_raw( get_admin_url() ),
                        'bulk_nonce'                 => wp_create_nonce( 'bulk-profile-forms' ),
                        'is_plain_permalink'         => empty( get_option( 'permalink_structure' ) ),
                        'permalink_settings_url'     => admin_url( 'options-permalink.php' ),
                        'ai_configured'              => $ai_configured,
                        'ai_form_builder_available'  => $ai_form_builder_available,
                        'ai_settings_url'            => admin_url( 'admin.php?page=wpuf-settings#wpuf_ai' ),
                        'template_nonce'             => wp_create_nonce( 'wpuf_create_from_template' ),
                    ]
                );

                require_once WPUF_PRO_INCLUDES . '/Admin/views/profile-forms-list-table-view.php';

                $registry       = ( new Profile_Form_Template() )->wpuf_get_profile_form_templates();
                $pro_templates  = wpuf_get_pro_form_previews();
                $blank_form_url = admin_url( 'admin.php?page=wpuf-profile-forms&action=add-new' );
                $action_name    = 'wpuf_profile_form_template';
                $footer_help    = sprintf(
                // translators: %s: mailto link
                    __( 'Want a new integration? <a href="%s" target="_blank">Let us know</a>.', 'wp-user-frontend' ), 'mailto:support@wedevs.com?subject=WPUF Custom Post Template Integration Request'
                );

                if ( ! $registry ) {
                    return;
                }

                if( file_exists( WPUF_ROOT . '/includes/Admin/template-parts/modal-v4.2.php' ) ) {
                    include WPUF_ROOT . '/includes/Admin/template-parts/modal-v4.2.php';
                } else {
                    include WPUF_ROOT . '/includes/Admin/template-parts/modal-v4.1.php';
                }

                break;
        }
    }

    /**
     * The action to run just after the menu is created
     *
     * @since 4.0.0
     *
     * @return void
     */
    public function profile_form_menu_action() {
        wp_enqueue_style( 'wpuf-admin' );
        wp_enqueue_style( 'wpuf-registration-forms' );
        wp_enqueue_script( 'wpuf-registration-forms' );
        /**
         * Backdoor for calling the menu hook.
         * This hook won't get translated even the site language is changed
         */
        do_action( 'wpuf_load_profile_forms' );
    }
}
