<?php

namespace WeDevs\Wpuf\Pro\Integrations\Events_Calendar\Compatibility;

/**
 * TEC Compatibility Manager (Pro)
 *
 * Handles version detection and routes to appropriate compatibility handler
 *
 * @since 4.1.8
 */
class TEC_Compatibility_Manager {
    /**
     * TEC version
     *
     * @var string
     */
    private $tec_version;

    /**
     * Compatibility handler instance
     *
     * @var TEC_Compatibility|TEC_Legacy_Compatibility|null
     */
    private $compatibility_handler;

    public function __construct() {
        $this->tec_version = $this->detect_tec_version();
        $this->compatibility_handler = $this->get_compatibility_handler();
    }

    /**
     * Detect The Events Calendar version
     *
     * @return string
     */
    private function detect_tec_version() {
        if ( class_exists( 'Tribe__Events__Main' ) ) {
            return defined( 'Tribe__Events__Main::VERSION' ) ? \Tribe__Events__Main::VERSION : '0.0.0';
        }
        return '0.0.0';
    }

    /**
     * Get the current TEC version
     *
     * @return string
     */
    public function get_tec_version() {
        return $this->tec_version;
    }

    /**
     * Get the appropriate compatibility handler
     *
     * @return TEC_Compatibility|TEC_Legacy_Compatibility|null
     */
    public function get_compatibility_handler() {
        if ( version_compare( $this->tec_version, '6.0', '>=' ) ) {
            return new TEC_Compatibility();
        } else {
            return new TEC_Legacy_Compatibility();
        }
    }
}
