<?php
/**
 * Cover Photo Upload API Handler
 * Handles cover photo upload and processing
 *
 * @since   4.2.3
 * @package WPUF\UserDirectory
 */

namespace WPUF\UserDirectory\Api;

use WPUF\UserDirectory\Api\ProfileImageUpload;

/**
 * Cover Photo Upload API Class
 */
class CoverPhotoUpload {

	/**
	 * Constructor
	 */
	public function __construct() {
		new ProfileImageUpload(
			[
				'action'            => 'wpuf_upload_cover_photo',
				'nonce_name'        => 'wpuf_cover_photo_upload_nonce',
				'file_input_name'   => 'cover_photo',
				'meta_key'          => 'wpuf_cover_photo',
				'processing_func'   => 'wpuf_ud_process_cover_photo_upload',
				'error_message'      => 'You can only upload cover photos for your own profile.',
				'success_message'   => 'Cover photo updated successfully!',
				'response_key'      => 'cover_photo_url',
			]
		);
	}
}

// Initialize the API handler
new CoverPhotoUpload();

